package com.xebialabs.deployit.hostsession.ssh;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.log4j.Logger;

import com.xebialabs.deployit.hostsession.HostFile;

/**
 * An output stream to a file on a host connected through SSH w/ SUDO.
 */
class SshSudoOutputStream extends OutputStream {

	private HostFile tempFile;

	private SshSudoHostFile hostFile;

	private long length;

	private OutputStream tempFileOutputStream;

	public SshSudoOutputStream(SshSudoHostFile hostFile, long length, HostFile tempFile) {
		this.hostFile = hostFile;
		this.length = length;
		this.tempFile = tempFile;
	}

	void open() {
		tempFileOutputStream = tempFile.put(length);
	}

	@Override
	public void write(int b) throws IOException {
		tempFileOutputStream.write(b);
	}

	@Override
	public void write(byte[] b, int off, int len) throws IOException {
		tempFileOutputStream.write(b, off, len);
	}

	@Override
	public void write(byte[] b) throws IOException {
		tempFileOutputStream.write(b);
	}

	@Override
	public void close() throws IOException {
		tempFileOutputStream.close();
		copyTempFileToHostFile();
	}

	private void copyTempFileToHostFile() {
		if (logger.isDebugEnabled())
			logger.debug("Copying " + tempFile + " to " + hostFile + " after writing");
		hostFile.getSession().execute(null, "cp", tempFile.getPath(), hostFile.getPath());
	}

	private Logger logger = Logger.getLogger(SshSudoOutputStream.class);

}
