package com.xebialabs.deployit.mapper;

import java.io.Serializable;

/**
 * A pair of objects.
 * 
 * @param <X>
 *            the type of the first element of the pair.
 * @param <Y>
 *            the type of the second element of the pair.
 */
@SuppressWarnings("serial")
public class Pair<X, Y> implements Serializable {

	private X first;

	private Y second;

	/**
	 * Creates a <tt>Pair</tt> with the specified elements.
	 * 
	 * @param first
	 *            the first element
	 * @param second
	 *            the second element
	 */
	public Pair(X first, Y second) {
		this.first = first;
		this.second = second;
	}

	/**
	 * Returns the first element.
	 * 
	 * @return the first element
	 */
	public X getFirst() {
		return first;
	}

	/**
	 * Set the first element of the pair.
	 * 
	 * @param first
	 *            the first element
	 */
	public void setFirst(X first) {
		this.first = first;
	}

	/**
	 * Returns the second element.
	 * 
	 * @return the second element
	 */
	public Y getSecond() {
		return second;
	}

	/**
	 * Set the second element of the pair.
	 * 
	 * @param second
	 *            the second element
	 */
	public void setSecond(Y second) {
		this.second = second;
	}

}