package com.xebialabs.deployit.mapper.artifact;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.artifact.mapping.ConfigurationFilesMapping;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.steps.DeleteStep;
import com.xebialabs.deployit.steps.PlaceholderReplacingCopyStep;

/**
 * Mapper that maps {@link ConfigurationFiles} CI's to {@link Host hosts} with {@link ConfigurationFilesMapping} CI's.
 */
public class ConfigurationFilesToHostMapper extends StepGeneratingMapper<ConfigurationFiles, ConfigurationFilesMapping, Host> {

	public ConfigurationFilesToHostMapper(Change<Deployment> c) {
		super(c, false);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(ConfigurationFiles newSource, ConfigurationFilesMapping m, Host newTarget, List<Step> steps) {
		Map<String, String> propertyMap = listOfKVPairsToMap(m.getKeyValuePairs());
		steps.add(new PlaceholderReplacingCopyStep(Host.getLocalHost(), ((ConfigurationFiles) m.getSource()).getLocation(), (Host) m.getTarget(), m
				.getTargetDirectory(), true, propertyMap));
	}

	private Map<String, String> listOfKVPairsToMap(List<KeyValuePair> keyValuePairs) {
		Map<String, String> map = new HashMap<String, String>();
		if (keyValuePairs != null) {
			for (KeyValuePair pair : keyValuePairs) {
				map.put(pair.getKey(), pair.getValue());
			}
		}
		return map;
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(ConfigurationFiles oldSource, ConfigurationFilesMapping m, Host oldTarget, List<Step> steps) {
		steps.add(new DeleteStep((Host) m.getTarget(), m.getTargetDirectory()));
	}

}
