package com.xebialabs.deployit.mapper.artifact;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.artifact.Libraries;
import com.xebialabs.deployit.ci.artifact.mapping.ConfigurationFilesMapping;
import com.xebialabs.deployit.ci.artifact.mapping.LibrariesMapping;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.steps.CopyStep;
import com.xebialabs.deployit.steps.DeleteStep;

/**
 * Mapper that maps {@link ConfigurationFiles} CI's to {@link Host hosts} with {@link LibrariesMapping} CI's. Libraries
 */
public class LibrariesToHostMapper extends StepGeneratingMapper<Libraries, LibrariesMapping, Host> {

	public LibrariesToHostMapper(Change<Deployment> c) {
		super(c, false);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(Libraries newSource, LibrariesMapping m, Host newTarget, List<Step> steps) {
		steps.add(new CopyStep(Host.getLocalHost(), ((Libraries) m.getSource()).getLocation(), (Host) m.getTarget(), m.getTargetDirectory(), true));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(Libraries oldSource, LibrariesMapping m, Host oldTarget, List<Step> steps) {
		steps.add(new DeleteStep((Host) m.getTarget(), m.getTargetDirectory()));
	}

}
