package com.xebialabs.deployit.reflect;

import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.ConfigurationItem;

/**
 * Enumeration of possible configuration item types.
 */
public enum ConfigurationItemPropertyType {
	/**
	 * A <tt>boolean</tt>.
	 */
	BOOLEAN,

	/**
	 * An <tt>int</tt>
	 */
	INTEGER,

	/**
	 * A {@link String}.
	 */
	STRING,

	/**
	 * An {@link Enum}.
	 */
	ENUM,

	/**
	 * A {@link List} of non-CI objects.
	 */
	LIST_OF_OBJECTS,

	/**
	 * A {@link Set} of {@link String}s.
	 */
	SET_OF_STRINGS,

	/**
	 * A reference to a {@link ConfigurationItem}.
	 */
	CI,

	/**
	 * A {@link Set} of references to {@link ConfigurationItem}s.
	 */
	SET_OF_CIS,

	/**
	 * An unsupported property type.
	 */
	UNSUPPORTED;

}
