package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;

/**
 * Steps that deletes a file or a directory on a host.
 */
@SuppressWarnings("serial")
public class DeleteStep extends HostSessionStep {

	private String locationToDelete;

	private String exclusionPattern;

	/**
	 * Creates a <tt>DeleteStep</tt> that deletes a file/directory on a remote host. Directories are deleted
	 * recursively.
	 * 
	 * @param host
	 *            the host
	 * @param pathToDelete
	 *            the file or directory to delete.
	 */
	public DeleteStep(Host host, String pathToDelete) {
		super(host);
		setDescription("Delete " + pathToDelete + " from " + host.getAddress());
		this.locationToDelete = pathToDelete;
		this.exclusionPattern = null;
	}

	/**
	 * Creates a <tt>DeleteStep</tt> that delete a file/directory on a remote host. Directories are deleted recursively.
	 * 
	 * @param host
	 *            the host
	 * @param pathToDelete
	 *            the file or directory to delete.
	 * @param exclusionPattern
	 *            a pattern of files that should not be removed when doing a recursive directory deletion. See
	 *            {@link HostFile#deleteRecursively(String)} for the specification of the pattern.
	 */
	public DeleteStep(Host host, String pathToDelete, String exclusionPattern) {
		super(host);
		setDescription("Delete " + pathToDelete + " from " + host.getAddress());
		this.locationToDelete = pathToDelete;
		this.exclusionPattern = exclusionPattern;
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession session = getHostSession();
		try {
			ctx.logOutput("Deleting " + locationToDelete);
			HostFile fileToDelete = session.getFile(locationToDelete);
			if (exclusionPattern != null) {
				return fileToDelete.deleteRecursively(exclusionPattern);
			} else {
				return fileToDelete.deleteRecursively();
			}
		} finally {
			session.close();
		}
	}

}
