package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;

/**
 * Base step for steps that performs execution and/or file manipulation on a host.
 */
@SuppressWarnings("serial")
public abstract class HostSessionStep implements Step {

	protected String description;

	protected Host host;

	public HostSessionStep(String description, Host host) {
		this.description = description;
		this.host = host;
	}

	public HostSessionStep(Host host) {
		this(null, host);
	}

	protected HostSession getHostSession() {
		HostSession s = HostSessionFactory.getHostSession(host.getOperatingSystemFamily(), host.getAccessMethod(), host.getAddress(), host.getUsername(), host
				.getPassword(), host.getSudoUsername(), host.getTemporaryDirectoryLocation());
		return s;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

}
