package com.xebialabs.deployit.steps;

import java.util.Map;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.util.TemplateResolver;

/**
 * @deprecated Use {@link CopyStep#CopyStep(Host, String, Host, String, boolean, Map)} instead.
 */
@SuppressWarnings("serial")
public class PlaceholderReplacingCopyStep extends CopyStep {

	private static final long MAX_FILE_SIZE = 1048576;

	public PlaceholderReplacingCopyStep(Host sourceHost, String sourceLocation, Host destinationHost, String destinationLocation,
			boolean createToplevelDirectory, Map<String, String> properties) {
		super(sourceHost, sourceLocation, destinationHost, destinationLocation, createToplevelDirectory, properties);
	}

	@Override
	public boolean execute(StepExecutionContext ctx) {
		HostSession sourceSession = getHostSession();
		HostSession destinationSession = HostSessionFactory.getHostSession(destinationHost);
		try {
			HostFile sourceFile = sourceSession.getFile(sourceLocation);

			HostFile destinationFile = destinationSession.getFile(destinationLocation);

			boolean parentIsCreated = false;
			if (createToplevelDirectory && !destinationFile.exists()) {
				ctx.logOutput("Creating directory " + destinationFile);
				destinationFile.mkdirs();
				parentIsCreated = true;
			}

			resolveRecursively(sourceFile, destinationSession, ctx, destinationFile, parentIsCreated);
			return true;
		} finally {
			sourceSession.close();
			destinationSession.close();
		}
	}

	private void resolveRecursively(HostFile sourceFile, HostSession destinationSession, StepExecutionContext ctx, HostFile destinationParentDir,
			boolean parentIsCreated) {
		if (sourceFile.isDirectory()) {
			HostFile childDestinationDir;
			if (parentIsCreated) {
				childDestinationDir = destinationParentDir;
			} else {
				childDestinationDir = destinationSession.getFile(destinationParentDir.getPath() + destinationHost.getFileSeparator() + sourceFile.getName());
			}
			if (!childDestinationDir.exists() && !parentIsCreated) {
				ctx.logOutput("Creating directory " + childDestinationDir);
				childDestinationDir.mkdirs();
			}
			for (HostFile child : sourceFile.listFiles()) {
				resolveRecursively(child, destinationSession, ctx, childDestinationDir, false);
			}
		} else {

			HostFile resolvedSimpleFile;
			if (properties != null && !properties.isEmpty()) {
				if (sourceFile.length() > MAX_FILE_SIZE) {
					throw new ResolutionException("Cannot handle " + sourceFile.getName() + ".File too large(>" + MAX_FILE_SIZE + " bytes)");
				}
				resolvedSimpleFile = new PlaceholderReplacingHostFile(sourceFile, new TemplateResolver(properties));
				System.out.println("returning resolved file " + resolvedSimpleFile.getName());
			} else {
				resolvedSimpleFile = sourceFile;
			}
			ctx.logOutput("Copying " + sourceFile + " to " + destinationParentDir);
			HostFileUtils.copy(resolvedSimpleFile, destinationParentDir);
		}
	}

}
