package com.xebialabs.deployit.util;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

import com.xebialabs.deployit.exception.RuntimeIOException;

/**
 * Provides a number of static methods that work on {@link Resource}s.
 */
public class ExtendedResourceUtils {

	/**
	 * Reads the contents of a {@link Resource} into a byte array.
	 * 
	 * @param resource
	 *            the resource.
	 * @return the byte array with the contents of the resource.
	 * @throws RuntimeIOException
	 *             when an I/O error occurs.
	 */
	public static byte[] toByteArray(Resource resource) throws RuntimeIOException {
		try {
			InputStream resourceIn = resource.getInputStream();
			try {
				return IOUtils.toByteArray(resourceIn);
			} finally {
				resourceIn.close();
			}
		} catch (IOException exc) {
			throw new RuntimeIOException("Cannot read resource " + resource, exc);
		}
	}

	/**
	 * Reads the contents of a {@link Resource} into a String.
	 * 
	 * @param resource
	 *            the resource.
	 * @return the String with the contents of the resource.
	 * @throws RuntimeIOException
	 *             when an I/O error occurs.
	 */
	public static String toString(Resource resource) throws RuntimeIOException {
		try {
			InputStream resourceIn = resource.getInputStream();
			try {
				return IOUtils.toString(resourceIn);
			} finally {
				resourceIn.close();
			}
		} catch (IOException exc) {
			throw new RuntimeIOException("Cannot read resource " + resource, exc);
		}
	}

}
