package com.xebialabs.deployit.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;

/**
 * Provides a number of utility methods for {@link Set}s.
 */
public class SetUtils {

	/**
	 * Subtracts one set from another.
	 * 
	 * @param <T>
	 *            the type of the objects in the sets.
	 * @param minuend
	 *            the set to subtract from
	 * @param subtrahend
	 *            the set to subtract
	 * @return the difference
	 */
	@SuppressWarnings("unchecked")
	public static <T> Set<T> subtract(Set<? extends T> minuend, Set<? extends T> subtrahend) {
		return new HashSet<T>(CollectionUtils.subtract(minuend, subtrahend));
	}

	/**
	 * Returns a variable number of arguments (or an array) as a set.
	 * 
	 * @param <T>
	 *            the type of the objects in the set.
	 * @param objs
	 *            the object to place in the set.
	 * @return the constructed set.
	 */
	public static <T> Set<T> asSet(T... objs) {
		return new HashSet<T>(Arrays.asList(objs));
	}

}
