/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.hostsession;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.util.TemplateResolver;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

import java.io.*;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * TODO: Rename it !!
 */
public class LenientTemplateResolvingArchiveHostFileInputTransformer implements HostFileInputStreamTransformer {

	private final TemplateResolver resolver;

	private final String supportedExtensionInArchiveFiles = System.getProperty("deployit.supported.extensions.in.archive", DEFAULT_SUPPORTED_EXTENSIONS);

    private static final String DEFAULT_SUPPORTED_EXTENSIONS = ".properties,.xml,.bat,.cmd,.sh,.sql,.txt";

    static class SupportedExtensionFilenameFile implements FilenameFilter {

		private final List<String> supportedFileExtensions;

		SupportedExtensionFilenameFile(String extensions) {
			supportedFileExtensions = Lists.newArrayList(extensions.split(","));
            logger.info("supported extensions in archives are (deployit.supported.extensions.in.archive): "+supportedFileExtensions);
		}

		public boolean accept(java.io.File file, String name) {
			for (String ext : supportedFileExtensions) {
				if (name.toLowerCase().endsWith(ext))
					return true;
			}
			return false;
		}
	}

	private final FilenameFilter filenameFilter = new SupportedExtensionFilenameFile(supportedExtensionInArchiveFiles);

	public LenientTemplateResolvingArchiveHostFileInputTransformer(Map<String, String> properties, PlaceholderFormat placeholderFormat) {
		this.resolver = new TemplateResolver(properties, placeholderFormat);
	}

	public InputStream transform(HostFile input) {
		final File archiveFile = new File(input.getPath());
		try {
            //Search if there are any candidate... cf supportedExtensionInArchiveFiles
			if (getCandidates(archiveFile, filenameFilter).isEmpty()) {
				logger.debug("no candidate files found in " + archiveFile);
				if (archiveFile.isArchive()) {
					return input.get();
				}
				//Not an archive file, handle it as a regular file.
				if (filenameFilter.accept(null, input.getName())) {
					logger.debug("regular supported files " + archiveFile);
					String inputFileAsString = HostFileUtils.getHostFileAsString(input);
					String resolvedFileAsString = resolver.resolveLenient(inputFileAsString);
					return new ByteArrayInputStream(resolvedFileAsString.getBytes());
				}
				logger.debug("no transformation");
				return null;
			}

			final HostSession session = input.getSession();
			final HostFile tempFile = session.getTempFile("lenientTemplate", ".zip");

			HostFileUtils.copy(input, tempFile);

			final File workArchiveFile = new File(tempFile.getPath());          
			final Collection<File> files = getCandidates(workArchiveFile, filenameFilter);

			for (File file : files) {
				logger.debug("resolving " + file);
				String inputFileAsString = getFileAsString(file);
				String resolvedFileAsString = resolver.resolveLenient(inputFileAsString);
				logger.debug(resolvedFileAsString);
				writeStringToFile(file, resolvedFileAsString);
			}

			//TODO: Check if the update could not be done at the instance Level...
			File.update();

			return tempFile.get();

		} catch (Exception e) {
			throw new RuntimeException("transform error", e);
		}
	}

	private void writeStringToFile(File file, String data) throws IOException {
		final FileOutputStream fileOutputStream = new FileOutputStream(file);
		final BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
		bufferedOutputStream.write(data.getBytes());
		bufferedOutputStream.close();
	}

	private String getFileAsString(File s) throws FileNotFoundException, UnsupportedEncodingException {
		final FileInputStream inputStream = new FileInputStream(s);
		final ByteArrayOutputStream bos = new ByteArrayOutputStream();
		try {
			try {
				IOUtils.copy(inputStream, bos);
			} finally {
				IOUtils.closeQuietly(inputStream);
			}
			byte[] contentBytes = bos.toByteArray();
			return new String(contentBytes, "UTF-8");
		} catch (IOException exc) {
			throw new RuntimeIOException(exc);
		}
		finally {
			IOUtils.closeQuietly(bos);
		}

	}


	private Collection<File> getCandidates(File file, FilenameFilter filter) {
		logger.debug("getCandidate " + file);
		List<File> candidates = Lists.newArrayList();
		final String[] items = file.list(filter);
		if (items == null)
			return candidates;

		for (String item : items) {
			candidates.add(new File(file, item));
		}

		final String[] directories = file.list(new FilenameFilter() {
			public boolean accept(java.io.File dir, String name) {
				return new File(dir, name).isDirectory();
			}
		});

		for (String dir : directories) {
			candidates.addAll(getCandidates(new File(file, dir), filter));
		}
		return candidates;
	}

	private static Logger logger = Logger.getLogger(HostFileUtils.class);
}
