/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.hostsession.ssh;

import org.apache.log4j.Logger;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;

/**
 * A session to a remote host using SSH w/ SFTP.
 */
public class SshSftpHostSession extends SshHostSession {

	private ChannelSftp sharedSftpChannel;

	/**
	 * Constructs an SshSftpHostSession
	 * 
	 * @param os
	 *            the operating system of the host
	 * @param temporaryDirectoryPath
	 *            the path of the directory in which to store temporary files
	 * @param host
	 *            the hostname or IP adress of the host
	 * @param port
	 *            the port to connect to
	 * @param username
	 *            the username to connect with
	 * @param password
	 *            the password to connect with
	 */
	public SshSftpHostSession(OperatingSystemFamily os, String temporaryDirectoryPath, String host, int port, String username, String password) {
		super(os, temporaryDirectoryPath, host, port, username, password);
		open();
	}

	@Override
	public HostFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
		return new SshSftpHostFile(this, hostPath);
	}

	@Override
	public void close() {
		super.close();

		if (sharedSftpChannel != null) {
			closeSftpChannel(sharedSftpChannel);
		}
	}

	protected ChannelSftp getSharedSftpChannel() throws JSchException {
		if (sharedSftpChannel == null) {
			sharedSftpChannel = openSftpChannel();
		}
		return sharedSftpChannel;
	}

	protected ChannelSftp openSftpChannel() throws JSchException {
		Channel channel = getSharedSession().openChannel("sftp");
		if (logger.isDebugEnabled())
			logger.debug("Opened SFTP channel to " + this);
		channel.connect();
		return (ChannelSftp) channel;
	}

	protected void closeSftpChannel(ChannelSftp sftpChannel) {
		if (sftpChannel != null) {
			sftpChannel.disconnect();
			if (logger.isDebugEnabled())
				logger.debug("Closed SFTP channel to " + this);
		}
	}

	public String toString() {
		return username + "@" + host + ":" + port + " (sftp)";
	}

	private Logger logger = Logger.getLogger(SshSftpHostSession.class);

}
