/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */


package com.xebialabs.deployit.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;

/**
 * A client to an SQL based database, such as SQL Plus (ORA) of MySql (MySqld)
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "SQL database instance")
public class Database extends BaseConfigurationItem {
	
	@ConfigurationItemProperty(required = true, asContainment = true, label = "Client host", description = "The host on which the SQL client is running")
	private Host host;
	
	@ConfigurationItemProperty(required = false, label = "Command", description = "The plain command to the SQL client, such as \"/home/centos/oracle/product/10.2.0/db_5/bin/sqlplus\" for Oracle or \"/usr/local/mysql/bin/mysql\" for MySql", size = Size.LARGE)
	private String command;
	
	@ConfigurationItemProperty(required = false, label = "Options", description = "All options for the command, such as \"${user}/${password}@${database}\" for Oracle or \"-u ${user} -p${password} ${database}\" for MySql", size = Size.LARGE)
	private String options;
	
	@ConfigurationItemProperty(required = true, label = "User", description = "value of the user option provided to the client command, replaces \"${user}\" in options")
	private String user;
	
	@ConfigurationItemProperty(required = true, label = "Password", description = "value of the password option provided to the client command, replaces \"${password}\" in options", password = true)
	private String password;
	
	@ConfigurationItemProperty(required = false, label = "Database", description = "value of the database option provided to the client command, replaces \"${database}\" in options")
	private String database;

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getCommand() {
		return command;
	}

	public void setCommand(String command) {
		this.command = command;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getDatabase() {
		return database;
	}

	public void setDatabase(String database) {
		this.database = database;
	}

	public String getOptions() {
		return options;
	}

	public void setOptions(String options) {
		this.options = options;
	}
	

}
