package com.xebialabs.deployit.ci.artifact.mapping;

import java.io.Serializable;


/**
 * Format of the placeholder that be used with template resolver
 */
public enum PlaceholderFormat implements Serializable {

	SPRING("${", "}"), WINDOWS_SHELL("%", "%"), STARS("*","*"),NONE("", "");

	private final String prefix;
	private final String postfix;

	PlaceholderFormat(String prefix, String postfix) {
		this.prefix = prefix;
		this.postfix = postfix;
	}

	/* Not supported in 1.3
	@Override
	public String toString() {
		return prefix + "..." + postfix;
	}
	*/

	public String getPrefix() {
		return prefix;
	}

	public String getPostfix() {
		return postfix;
	}
}
