package com.xebialabs.deployit.exception;

/**
 * Exception to be thrown by a step when its execution has been aborted.
 */
@SuppressWarnings("serial")
public class AbortedException extends RuntimeException {

	/**
	 * Constructs an AbortedException with a message.
	 * 
	 * @param message
	 *            the message
	 */
	public AbortedException(String message) {
		super(message);
	}

	/**
	 * Constructs an AbortedException with a message and a cause.
	 * 
	 * @param message
	 *            the message
	 * @param cause
	 *            the exception
	 */
	public AbortedException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Constructs an AbortedException with a cause.
	 * 
	 * @param cause
	 *            the original exception
	 */
	public AbortedException(Throwable cause) {
		super(cause);
	}

}
