package com.xebialabs.deployit.util;

import com.xebialabs.deployit.exception.AbortedException;

public class StepUtils {

	/**
	 * Checks whether this steps is to be aborted and throws an {@link AbortedException} when that is the case.
	 * 
	 * @param action
	 *            a description of what the step is doing. Used to generated the message for the exception.
	 */
	public static void checkAbortion(String action) {
		if (Thread.currentThread().isInterrupted()) {
			throw new AbortedException("Step was aborted while " + action);
		}
	}

}
