/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.mapping.EjbReference;
import com.xebialabs.deployit.ci.mapping.ResourceReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarFileInfoExtractor {
    public static List<ResourceReference> getResourceReferences(War war) {
        ArrayList<ResourceReference> resourceReferences = new ArrayList<ResourceReference>();
        NodeList resourceRefNodes = WarFileInfoExtractor.getNodesWithTag(war, "resource-ref");
        if (resourceRefNodes != null) {
            for (int i = 0; resourceRefNodes != null && i < resourceRefNodes.getLength(); ++i) {
                Element resourceRefNode = (Element)resourceRefNodes.item(i);
                String name = WarFileInfoExtractor.findName(resourceRefNode, "res-ref-name");
                String type = WarFileInfoExtractor.findName(resourceRefNode, "res-type");
                if (!StringUtils.isNotBlank((String)name)) continue;
                resourceReferences.add(new ResourceReference(name, type, ""));
            }
        }
        return resourceReferences;
    }

    public static List<ResourceReference> getResourceEnvironmentEntryReferences(War war) {
        ArrayList<ResourceReference> resourceEnvironmentReferences = new ArrayList<ResourceReference>();
        NodeList resourceEnvRefNodes = WarFileInfoExtractor.getNodesWithTag(war, "resource-env-ref");
        if (resourceEnvRefNodes != null) {
            for (int i = 0; resourceEnvRefNodes != null && i < resourceEnvRefNodes.getLength(); ++i) {
                Element resourceEnvRefNode = (Element)resourceEnvRefNodes.item(i);
                String name = WarFileInfoExtractor.findName(resourceEnvRefNode, "resource-env-ref-name");
                String type = WarFileInfoExtractor.findName(resourceEnvRefNode, "resource-env-ref-type");
                if (name == null || type == null) continue;
                resourceEnvironmentReferences.add(new ResourceReference(name, type, ""));
            }
        }
        return resourceEnvironmentReferences;
    }

    public static List<EjbReference> getEjbReferences(War war) {
        ArrayList<EjbReference> ejbReferencesAndLocals = new ArrayList<EjbReference>();
        NodeList ejbLocalRefNodes = WarFileInfoExtractor.getNodesWithTag(war, "ejb-local-ref");
        if (ejbLocalRefNodes != null) {
            for (int i = 0; i < ejbLocalRefNodes.getLength(); ++i) {
                Element ejbLocalRefNode = (Element)ejbLocalRefNodes.item(i);
                String name = WarFileInfoExtractor.findName(ejbLocalRefNode, "ejb-ref-name");
                String local = WarFileInfoExtractor.findName(ejbLocalRefNode, "local");
                if (name == null || local == null) continue;
                ejbReferencesAndLocals.add(new EjbReference(name, local, ""));
            }
        }
        return ejbReferencesAndLocals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static NodeList getNodesWithTag(War war, String tag) {
        try {
            JarFile jarFile = new JarFile(new File(war.getLocation()));
            try {
                NodeList nodeList;
                JarEntry jarEntry = jarFile.getJarEntry("WEB-INF/web.xml");
                if (jarEntry == null) {
                    NodeList nodeList2 = null;
                    return nodeList2;
                }
                InputStream is = jarFile.getInputStream(jarEntry);
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    WarFileInfoExtractor.disableDtdValidation(db);
                    nodeList = db.parse(new InputSource(is)).getElementsByTagName(tag);
                }
                catch (Throwable throwable) {
                    is.close();
                    throw throwable;
                }
                is.close();
                return nodeList;
            }
            finally {
                jarFile.close();
            }
        }
        catch (Exception e) {
            throw new ResolutionException("Problems occurred while trying to parse " + war.getName() + " for finding value of tag:" + tag + " (location " + war.getLocation() + ")", e);
        }
    }

    private static String findName(Element element, String tagnameOfChild) {
        NodeList refNameElements = element.getElementsByTagName(tagnameOfChild);
        if (refNameElements.getLength() == 1) {
            Node refNameElement = refNameElements.item(0);
            return refNameElement.getFirstChild().getNodeValue();
        }
        return null;
    }

    private static void disableDtdValidation(DocumentBuilder db) {
        db.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                System.out.println("Ignoring " + publicId + ", " + systemId);
                return new InputSource(new StringReader(""));
            }
        });
    }
}

