/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemRoot;
import com.xebialabs.deployit.ci.HostAccessMethod;
import com.xebialabs.deployit.ci.Hosted;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;

@ConfigurationItem(root=ConfigurationItemRoot.INFRASTRUCTURE, category="hosts", description="A machine that runs middleware. Used to find out how to connect to the machine to run configuration and installation commands. Contains as its members the middleware CI's running on it (ApacheHttpd, WebSphereCell, etc.).")
public class Host
extends BaseConfigurationItem
implements Hosted {
    @ConfigurationItemProperty(required=true, discoveryParam=true, description="The type of operating system this host is running, Valid examples; Windows, Unix")
    private OperatingSystemFamily operatingSystemFamily;
    @ConfigurationItemProperty(required=true, discoveryParam=true, description="How deployit will access this host. For local use use local, for remote access use the rest of the options.")
    private HostAccessMethod accessMethod;
    @ConfigurationItemProperty(required=true, discoveryParam=true, description="Where to access this host. Valid examples; www.xebialabs.com, localhost, 127.0.0.1, 172.16.1.3")
    private String address;
    @ConfigurationItemProperty(required=false, discoveryParam=true, description="The username needed to connect to this host.")
    private String username;
    @ConfigurationItemProperty(required=false, discoveryParam=true, description="The password used to authenticate the username with.", password=true)
    private String password;
    @ConfigurationItemProperty(required=false, discoveryParam=true, description="When using the SSH_SUDO access method, deployit will use the sudo username to execute command on this host.")
    private String sudoUsername;
    @ConfigurationItemProperty(required=false, discoveryParam=true, discoveryRequired=false, description="Overrides the location (on windows \\TEMP, on unix /tmp) where deployit will store temporary files.", size=ConfigurationItemProperty.Size.LARGE)
    private String temporaryDirectoryLocation;

    public OperatingSystemFamily getOperatingSystemFamily() {
        return this.operatingSystemFamily;
    }

    public String getScriptExtension() {
        return this.getOperatingSystemFamily().getScriptExtension();
    }

    public String getLineSeparator() {
        return this.getOperatingSystemFamily().getLineSeparator();
    }

    public String getFileSeparator() {
        return this.getOperatingSystemFamily().getFileSeparator();
    }

    public String getPathSeparator() {
        return this.getOperatingSystemFamily().getPathSeparator();
    }

    public void setOperatingSystemFamily(OperatingSystemFamily operatingSystemFamily) {
        this.operatingSystemFamily = operatingSystemFamily;
    }

    public HostAccessMethod getAccessMethod() {
        return this.accessMethod;
    }

    public void setAccessMethod(HostAccessMethod accessMethod) {
        this.accessMethod = accessMethod;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSudoUsername() {
        return this.sudoUsername;
    }

    public void setSudoUsername(String sudoUsername) {
        this.sudoUsername = sudoUsername;
    }

    public String getTemporaryDirectoryLocation() {
        return this.temporaryDirectoryLocation;
    }

    public void setTemporaryDirectoryLocation(String temporaryDirectoryLocation) {
        this.temporaryDirectoryLocation = temporaryDirectoryLocation;
    }

    public static Host getLocalHost() {
        Host localHost = new Host();
        localHost.label = "localhost";
        localHost.setAddress("localhost");
        if (System.getProperty("os.name").startsWith("Windows")) {
            localHost.setOperatingSystemFamily(OperatingSystemFamily.WINDOWS);
        } else {
            localHost.setOperatingSystemFamily(OperatingSystemFamily.UNIX);
        }
        localHost.setAccessMethod(HostAccessMethod.LOCAL);
        localHost.setTemporaryDirectoryLocation(System.getProperty("java.io.tmpdir", localHost.getOperatingSystemFamily().getDefaultTemporaryDirectoryPath()));
        localHost.setUsername(System.getProperty("user.name", ""));
        localHost.setPassword("");
        localHost.setSudoUsername("");
        return localHost;
    }

    public HostSession getHostSession() {
        return HostSessionFactory.getHostSession(this);
    }

    public Host getHost() {
        return this;
    }
}

