/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.util.TemplateResolver;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LenientTemplateResolvingArchiveHostFileInputTransformer
implements HostFileInputStreamTransformer {
    private final TemplateResolver resolver;
    private final String supportedExtensionInArchiveFiles = System.getProperty("deployit.supported.extensions.in.archive", ".properties,.xml,.bat,.cmd,.sh,.sql,.txt");
    private static final String DEFAULT_SUPPORTED_EXTENSIONS = ".properties,.xml,.bat,.cmd,.sh,.sql,.txt";
    private final FilenameFilter filenameFilter = new SupportedExtensionFilenameFile(this.supportedExtensionInArchiveFiles);
    private static Logger logger = LoggerFactory.getLogger(HostFileUtils.class);

    public LenientTemplateResolvingArchiveHostFileInputTransformer(Map<String, String> properties, PlaceholderFormat placeholderFormat) {
        this.resolver = new TemplateResolver(properties, placeholderFormat);
    }

    @Override
    public HostFileInputStreamTransformer.TransformedInputStream transform(HostFile input) {
        de.schlichtherle.io.File archiveFile = new de.schlichtherle.io.File(input.getPath());
        try {
            if (this.getCandidates(archiveFile, this.filenameFilter).isEmpty()) {
                logger.debug("no candidate files found in " + archiveFile);
                if (archiveFile.isArchive()) {
                    return new HostFileInputStreamTransformer.TransformedInputStream(input.get(), input.length());
                }
                if (!this.filenameFilter.accept(null, input.getName())) {
                    logger.info("filtering a non text file " + archiveFile + " please check it is ok or put it in another CI");
                }
                logger.debug("regular supported files " + archiveFile);
                String inputFileAsString = HostFileUtils.getHostFileAsString(input);
                String resolvedFileAsString = this.resolver.resolveLenient(inputFileAsString);
                byte[] resolvedFileAsStringBytes = resolvedFileAsString.getBytes();
                return new HostFileInputStreamTransformer.TransformedInputStream(new ByteArrayInputStream(resolvedFileAsStringBytes), resolvedFileAsStringBytes.length);
            }
            HostSession session = input.getSession();
            HostFile tempFile = session.getTempFile("lenientTemplate", ".zip");
            HostFileUtils.copy(input, tempFile);
            de.schlichtherle.io.File workArchiveFile = new de.schlichtherle.io.File(tempFile.getPath());
            Collection<de.schlichtherle.io.File> files = this.getCandidates(workArchiveFile, this.filenameFilter);
            for (de.schlichtherle.io.File file : files) {
                logger.debug("resolving " + file);
                String inputFileAsString = this.getFileAsString(file);
                String resolvedFileAsString = this.resolver.resolveLenient(inputFileAsString);
                logger.debug(resolvedFileAsString);
                this.writeStringToFile(file, resolvedFileAsString);
            }
            de.schlichtherle.io.File.update();
            return new HostFileInputStreamTransformer.TransformedInputStream(tempFile.get(), tempFile.length());
        }
        catch (Exception e) {
            throw new RuntimeException("transform error", e);
        }
    }

    private void writeStringToFile(de.schlichtherle.io.File file, String data) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream((File)file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)fileOutputStream);
        bufferedOutputStream.write(data.getBytes());
        bufferedOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileAsString(de.schlichtherle.io.File s) throws FileNotFoundException, UnsupportedEncodingException {
        FileInputStream inputStream = new FileInputStream((File)s);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            byte[] contentBytes = bos.toByteArray();
            String string = new String(contentBytes, "UTF-8");
            return string;
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bos);
        }
    }

    private Collection<de.schlichtherle.io.File> getCandidates(de.schlichtherle.io.File file, FilenameFilter filter) {
        String[] directories;
        logger.debug("getCandidate " + file);
        ArrayList candidates = Lists.newArrayList();
        String[] items = file.list(filter);
        if (items == null) {
            return candidates;
        }
        for (String item : items) {
            candidates.add(new de.schlichtherle.io.File((File)file, item));
        }
        for (String dir : directories = file.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return new de.schlichtherle.io.File(dir, name).isDirectory();
            }
        })) {
            candidates.addAll(this.getCandidates(new de.schlichtherle.io.File((File)file, dir), filter));
        }
        return candidates;
    }

    static class SupportedExtensionFilenameFile
    implements FilenameFilter {
        private final List<String> supportedFileExtensions;

        SupportedExtensionFilenameFile(String extensions) {
            this.supportedFileExtensions = Lists.newArrayList((Object[])extensions.split(","));
            logger.info("supported extensions in archives are (deployit.supported.extensions.in.archive): " + this.supportedFileExtensions);
        }

        public boolean accept(File file, String name) {
            for (String ext : this.supportedFileExtensions) {
                if (!name.toLowerCase().endsWith(ext)) continue;
                return true;
            }
            return false;
        }
    }
}

