/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.ci.Database;
import com.xebialabs.deployit.ci.artifact.SqlScript;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.util.TemplateResolver;
import java.io.File;
import java.util.HashMap;

public class RunSqlScriptOnDatabaseStep
implements Step {
    private Database client;
    private SqlScript script;
    protected String description;

    public RunSqlScriptOnDatabaseStep(Database client, SqlScript script) {
        this.client = client;
        this.script = script;
        this.description = "Running SQL script " + script.getLabel() + " on SQL database " + client.getLabel();
    }

    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.client.getHost().getHostSession();
        try {
            StepExecutionContextCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
            String scriptPath = s.copyToTemporaryFile(new File(this.script.getLocation())).getPath();
            String command = this.client.getCommand();
            String unresolvedOptions = this.client.getOptions();
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("user", this.client.getUser());
            variables.put("password", this.client.getPassword());
            variables.put("database", this.client.getDatabase());
            TemplateResolver resolver = new TemplateResolver(variables);
            String resolvedOptions = resolver.resolveLenient(unresolvedOptions);
            return s.execute((CommandExecutionCallbackHandler)handler, command, resolvedOptions, scriptPath) == 0;
        }
        catch (RuntimeIOException exc) {
            throw new RuntimeIOException("Cannot execute remote command \"" + this.client.getCommand() + "\" on " + this.client.getHost(), exc);
        }
    }

    public String getDescription() {
        return this.description;
    }
}

