/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.local;

import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.common.AbstractHostFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalHostFile
extends AbstractHostFile {
    private File file;

    public LocalHostFile(HostSession session, File file) {
        super(session);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getParent() {
        return this.file.getParent();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public long length() throws RuntimeIOException {
        return this.file.length();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public boolean canExecute() {
        if (this.session.getHostOperatingSystem() == OperatingSystemFamily.UNIX) {
            return this.executeStat().canExecute;
        }
        return this.canRead();
    }

    @Override
    public List<String> list() throws RuntimeIOException {
        String[] listArray = this.file.list();
        if (listArray == null) {
            return null;
        }
        return Arrays.asList(listArray);
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        if (!this.file.mkdir()) {
            throw new RuntimeIOException("Cannot create directory " + this.file.getPath());
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        if (this.file.exists()) {
            return;
        }
        if (!this.file.mkdirs()) {
            throw new RuntimeIOException("Cannot create directory " + this.file.getPath() + " or one of its parent directories");
        }
    }

    @Override
    public void moveTo(HostFile destFile) throws RuntimeIOException {
        if (destFile instanceof LocalHostFile) {
            File destLocalFile = ((LocalHostFile)destFile).getFile();
            if (!this.file.renameTo(destLocalFile)) {
                throw new RuntimeIOException("Cannot move/rename " + this + " to " + destFile);
            }
        } else {
            throw new RuntimeIOException("Cannot move/rename local file/directory " + this + " to non-local file/directory " + destFile);
        }
    }

    @Override
    public boolean delete() {
        if (this.file.exists()) {
            if (!this.file.delete()) {
                throw new RuntimeIOException("Cannot delete " + this.file.getPath());
            }
            return true;
        }
        return false;
    }

    @Override
    public InputStream get() throws RuntimeIOException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    @Override
    public OutputStream put(long length) throws RuntimeIOException {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    protected int executeCommand(CommandExecutionCallbackHandler handler, CmdLine command) {
        return this.session.execute(handler, command);
    }
}

