/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshInteractiveSudoPasswordHandlingStream
extends FilterInputStream {
    private final OutputStream remoteStdin;
    private final byte[] passwordBytes;
    private final StringBuilder receivedOutputBuffer = new StringBuilder();
    private boolean onFirstLine = true;
    private static Logger logger = LoggerFactory.getLogger(SshInteractiveSudoPasswordHandlingStream.class);

    protected SshInteractiveSudoPasswordHandlingStream(InputStream remoteStdout, OutputStream remoteStdin, String password) {
        super(remoteStdout);
        this.remoteStdin = remoteStdin;
        this.passwordBytes = (password + "\r\n").getBytes();
    }

    public int read() throws IOException {
        int readInt = super.read();
        if (readInt > -1) {
            this.handleChar((char)readInt);
        }
        return readInt;
    }

    private void handleChar(char c) {
        if (this.onFirstLine) {
            switch (c) {
                case ':': {
                    String receivedOutput = this.receivedOutputBuffer.toString();
                    if (!receivedOutput.endsWith("assword")) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found password prompt in first line of output: " + receivedOutput);
                    }
                    try {
                        this.remoteStdin.write(this.passwordBytes);
                        this.remoteStdin.flush();
                        if (!logger.isDebugEnabled()) break;
                        logger.debug("Sent password");
                    }
                    catch (IOException exc) {
                        logger.error("Cannot send password", (Throwable)exc);
                    }
                    break;
                }
                case '\n': {
                    this.onFirstLine = false;
                    break;
                }
                default: {
                    this.receivedOutputBuffer.append(c);
                }
            }
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int numBytesRead = super.read(b, off, len);
        if (numBytesRead > -1) {
            for (int i = 0; i < numBytesRead; ++i) {
                this.handleChar((char)b[off + i]);
            }
        }
        return numBytesRead;
    }
}

