/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.common.HostFileCopier;
import com.xebialabs.deployit.hostsession.common.HostFileDirectoryWalker;
import com.xebialabs.deployit.hostsession.ssh.SshScpHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshScpProtocolHelper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshScpDirectoryCopier
extends HostFileDirectoryWalker {
    private HostFile scrDir;
    private SshScpHostFile targetDir;
    private HostFileInputStreamTransformer transformer;
    private SshScpProtocolHelper protocolHelper;
    private Logger logger = LoggerFactory.getLogger(SshScpDirectoryCopier.class);

    protected SshScpDirectoryCopier(HostFile srcDir, SshScpHostFile dstDir, HostFileInputStreamTransformer transformer) {
        HostFileCopier.checkDirectoryExists(srcDir, "Source");
        this.scrDir = srcDir;
        this.targetDir = dstDir;
        this.transformer = transformer;
        this.protocolHelper = new SshScpProtocolHelper(dstDir.sshHostSession, dstDir.getPath());
    }

    protected void handleDirectoryStart(HostFile directory, int depth) throws IOException {
        this.protocolHelper.sendDirectoryPreamble(directory);
        this.protocolHelper.readAck();
    }

    protected void handleFile(HostFile file, int depth) throws IOException {
        HostFileInputStreamTransformer.TransformedInputStream transformedIS = HostFileCopier.transform(file, this.transformer);
        this.protocolHelper.sendFilePreamble(file, transformedIS.length());
        this.protocolHelper.readAck();
        this.protocolHelper.write(transformedIS);
        this.protocolHelper.sendAck();
    }

    protected void handleDirectoryEnd(HostFile directory, int depth) throws IOException {
        this.protocolHelper.sendDirectoryPostscript(directory);
        this.protocolHelper.readAck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCopy() {
        try {
            this.openConnection();
            this.walk(this.scrDir);
        }
        finally {
            this.closeConnection();
        }
    }

    private void openConnection() {
        this.protocolHelper.open("rt");
        this.protocolHelper.readAck();
        this.logger.info("Opened SCP stream to write to remote dir " + this.targetDir);
    }

    private void closeConnection() {
        this.protocolHelper.close();
    }
}

