/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.ci;

import static com.xebialabs.deployit.ConfigurationItemRoot.INFRASTRUCTURE;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;

/**
 * A machine that runs middleware.
 */
@SuppressWarnings("serial")
@ConfigurationItem(root = INFRASTRUCTURE, category = "hosts", description = "A machine that runs middleware. Used to find out how to connect to the machine to run configuration and installation commands. Contains as its members the middleware CI's running on it (ApacheHttpd, WebSphereCell, etc.).")
public class Host extends BaseConfigurationItem implements Hosted {

	@ConfigurationItemProperty(required = true, discoveryParam = true, description = "The type of operating system this host is running, Valid examples; Windows, Unix")
	private OperatingSystemFamily operatingSystemFamily;

	@ConfigurationItemProperty(required = true, discoveryParam = true, description = "How deployit will access this host. For local use use local, for remote access use the rest of the options.")
	private HostAccessMethod accessMethod;

	@ConfigurationItemProperty(required = true, discoveryParam = true, description = "Where to access this host. Valid examples; www.xebialabs.com, localhost, 127.0.0.1, 172.16.1.3")
	private String address;

	@ConfigurationItemProperty(required = false, discoveryParam = true, description = "The username needed to connect to this host.")
	private String username;

	@ConfigurationItemProperty(required = false, discoveryParam = true, description = "The password used to authenticate the username with.", password = true)
	private String password;

	@ConfigurationItemProperty(required = false, discoveryParam = true, description = "When using the SSH_SUDO access method, deployit will use the sudo username to execute command on this host.")
	private String sudoUsername;

	@ConfigurationItemProperty(required = false, discoveryParam = true, discoveryRequired = false, description = "Overrides the location (on windows \\TEMP, on unix /tmp) where deployit will store temporary files.", size = Size.LARGE)
	private String temporaryDirectoryLocation;

	public OperatingSystemFamily getOperatingSystemFamily() {
		return operatingSystemFamily;
	}

	public String getScriptExtension() {
		return getOperatingSystemFamily().getScriptExtension();
	}

	public String getLineSeparator() {
		return getOperatingSystemFamily().getLineSeparator();
	}

	public String getFileSeparator() {
		return getOperatingSystemFamily().getFileSeparator();
	}

	public String getPathSeparator() {
		return getOperatingSystemFamily().getPathSeparator();
	}

	public void setOperatingSystemFamily(OperatingSystemFamily operatingSystemFamily) {
		this.operatingSystemFamily = operatingSystemFamily;
	}

	public HostAccessMethod getAccessMethod() {
		return accessMethod;
	}

	public void setAccessMethod(HostAccessMethod accessMethod) {
		this.accessMethod = accessMethod;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getSudoUsername() {
		return sudoUsername;
	}

	public void setSudoUsername(String sudoUsername) {
		this.sudoUsername = sudoUsername;
	}

	public String getTemporaryDirectoryLocation() {
		return temporaryDirectoryLocation;
	}

	public void setTemporaryDirectoryLocation(String temporaryDirectoryLocation) {
		this.temporaryDirectoryLocation = temporaryDirectoryLocation;
	}

	public static Host getLocalHost() {
		Host localHost = new Host();
		localHost.label = "localhost";
		localHost.setAddress("localhost");
		if (System.getProperty("os.name").startsWith("Windows")) {
			localHost.setOperatingSystemFamily(OperatingSystemFamily.WINDOWS);
		} else {
			localHost.setOperatingSystemFamily(OperatingSystemFamily.UNIX);
		}
		localHost.setAccessMethod(HostAccessMethod.LOCAL);
		localHost.setTemporaryDirectoryLocation(System.getProperty("java.io.tmpdir", localHost.getOperatingSystemFamily().getDefaultTemporaryDirectoryPath()));
		localHost.setUsername(System.getProperty("user.name", ""));
		localHost.setPassword("");
		localHost.setSudoUsername("");
		return localHost;
	}

	public HostSession getHostSession() {
		return HostSessionFactory.getHostSession(this);
	}

	public Host getHost() {
		return this;
	}
}
