package com.xebialabs.deployit.hostsession;

import java.io.Serializable;

public class CmdLineArgument implements Serializable {
    private String arg;

    private boolean isPassword;

    private CmdLineArgument(String arg, boolean password) {
        this.arg = arg;
        isPassword = password;
    }

    public static CmdLineArgument arg(String arg) {
        return new CmdLineArgument(arg, false);
    }

    public static CmdLineArgument password(String arg) {
        return new CmdLineArgument(arg, true);
    }

    /**
     * Will hide the password by default.
     * @return
     */
    @Override
    public String toString() {
        return toString(true);
    }

    public String toString(boolean forLogging) {
        if (isPassword() && forLogging) {
            return "********";
        }
        return arg;
    }

    public boolean isPassword() {
        return isPassword;
    }

    public String getArg() {
        return arg;
    }
}
