/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.ssh.SshScpHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshScpProtocolHelper;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshScpInputStream
extends InputStream {
    protected SshScpHostFile file;
    protected long bytesRemaining;
    private SshScpProtocolHelper protocolHelper;
    private Logger logger = LoggerFactory.getLogger(SshScpInputStream.class);

    SshScpInputStream(SshScpHostFile file) {
        this.file = file;
        this.protocolHelper = new SshScpProtocolHelper(file.sshHostSession, file.getPath());
    }

    void open() {
        try {
            this.protocolHelper.open("f");
            this.protocolHelper.sendAck();
            this.protocolHelper.readAck(67);
            this.readPermissions();
            this.bytesRemaining = this.readFileLength();
            this.readFilename();
            this.protocolHelper.sendAck();
            this.logger.info("Opened SCP stream to read from remote file " + this.file);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot open SCP stream to read remote file " + this.file, exc);
        }
    }

    private void readPermissions() throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Reading permissions");
        }
        byte[] buf = new byte[5];
        this.protocolHelper.getChannelIn().read(buf, 0, 5);
    }

    private long readFileLength() throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Reading file length");
        }
        long filelength = 0L;
        while (true) {
            int c;
            if ((c = this.protocolHelper.getChannelIn().read()) < 0) {
                throw new RuntimeIOException("Protocol error on SCP stream to read remote file " + this.file);
            }
            if (c == 32) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("File length = " + filelength);
                }
                return filelength;
            }
            filelength = filelength * 10L + (long)(c - 48);
        }
    }

    private void readFilename() throws IOException {
        int c;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Reading file name");
        }
        do {
            if ((c = this.protocolHelper.getChannelIn().read()) >= 0) continue;
            throw new RuntimeIOException("Protocol error on SCP stream to read remote file " + this.file);
        } while (c != 10);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRemaining > 0L) {
            int bytesRead = this.protocolHelper.getChannelIn().read(b, off, (int)Math.min((long)len, this.bytesRemaining));
            this.bytesRemaining -= (long)bytesRead;
            return bytesRead;
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRemaining > 0L) {
            int b = this.protocolHelper.getChannelIn().read();
            if (b >= 0) {
                --this.bytesRemaining;
            }
            return b;
        }
        return -1;
    }

    @Override
    public void close() {
        try {
            this.protocolHelper.readAck();
            this.protocolHelper.sendAck();
        }
        catch (IOException ignore) {
        }
        catch (RuntimeIOException runtimeIOException) {
            // empty catch block
        }
        this.protocolHelper.close();
    }
}

