/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.mapper.artifact;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.Hosted;
import com.xebialabs.deployit.ci.artifact.Folder;
import com.xebialabs.deployit.ci.artifact.mapping.FolderMapping;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.steps.CopyStep;
import com.xebialabs.deployit.steps.DeleteStep;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FolderToHostMapper<S extends Folder, M extends FolderMapping<? super S, ? super T>, T extends Hosted>
extends StepGeneratingMapper<S, M, T> {
    public FolderToHostMapper(Change<Deployment> change) {
        super(change, false);
    }

    @Override
    protected void generateAdditionStepsForAddedMapping(S newSource, M m, T newMappingTarget, List<Step> steps) {
        this.generateAdditionStepsForAddedMapping((FolderMapping<?, ?>)m, newMappingTarget.getHost(), steps);
    }

    @Override
    protected void generateDeletionStepsForDeletedMapping(S oldSource, M m, T oldMappingTarget, List<Step> steps) {
        this.generateDeletionStepsForDeletedMapping((FolderMapping<?, ?>)m, oldMappingTarget.getHost(), steps);
    }

    protected void generateAdditionStepsForAddedMapping(FolderMapping<?, ?> folderMapping, Host host, List<Step> steps) {
        if (StringUtils.isBlank((String)folderMapping.getTargetDirectory())) {
            throw new ResolutionException("Target directory not specified for mapping " + folderMapping);
        }
        Folder sourceFolder = (Folder)folderMapping.getSource();
        Map<String, String> propertyMap = KeyValuePair.toMap(folderMapping.getKeyValuePairs());
        PlaceholderFormat placeholderFormat = folderMapping.getPlaceholderFormat();
        CopyStep step = new CopyStep(Host.getLocalHost(), sourceFolder.getLocation(), host, folderMapping.getTargetDirectory(), propertyMap, placeholderFormat);
        step.setCreateToplevelDirectory(folderMapping.isCreateIfNotExist());
        step.setDescription(step.getDescription() + " (CI:" + sourceFolder.getLabel() + ")");
        steps.add(step);
    }

    protected void generateDeletionStepsForDeletedMapping(FolderMapping<?, ?> folderMapping, Host host, List<Step> steps) {
        Folder sourceFolder = (Folder)folderMapping.getSource();
        if (!folderMapping.isShared()) {
            DeleteStep step = new DeleteStep(host, folderMapping.getTargetDirectory());
            step.setDescription(step.getDescription() + " (CI:" + sourceFolder.getLabel() + ")");
            steps.add(step);
        } else {
            for (File f : sourceFolder.getFiles()) {
                String fileToDelete = new File(folderMapping.getTargetDirectory(), f.getName()).getPath();
                DeleteStep step = new DeleteStep(host, fileToDelete);
                step.setDescription(step.getDescription() + " (CI:" + sourceFolder.getLabel() + ")");
                steps.add(step);
            }
        }
    }
}

