/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.cifs;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.cifs.CifsHostFile;
import com.xebialabs.deployit.hostsession.common.AbstractHostSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import jcifs.smb.SmbFile;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CifsTelnetHostSession
extends AbstractHostSession
implements HostSession {
    private String address;
    private String username;
    private String password;
    private static final String DETECTABLE_WINDOWS_PROMPT = "WINDOWS4DEPLOYIT ";
    private static final String ERRORLEVEL_PREAMBLE = "ERRORLEVEL-PREAMBLE";
    private static final String ERRORLEVEL_POSTAMBLE = "ERRORLEVEL-POSTAMBLE";
    public static final int EXITCODE_CANNOT_DETERMINE_ERRORLEVEL = -999999;
    private static Logger logger = LoggerFactory.getLogger(CifsTelnetHostSession.class);

    public CifsTelnetHostSession(OperatingSystemFamily osFamily, String temporaryDirectoryPath, String address, int port, String username, String password) {
        super(osFamily, temporaryDirectoryPath);
        this.address = address;
        this.username = username;
        this.password = password;
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, CmdLine commandLine) throws RuntimeIOException {
        return this.execute(handler, (Map<String, String>)Collections.EMPTY_MAP, commandLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(CommandExecutionCallbackHandler handler, Map<String, String> inputResponse, CmdLine command) {
        String commandLineForExecution = this.encodeCommandLineForExecution(command);
        String commandLineForLogging = this.encodeCommandLineForLogging(command);
        try {
            TelnetClient tc = new TelnetClient();
            tc.setConnectTimeout(120000);
            tc.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(299, 25, true, false, true, false));
            tc.connect(this.address);
            try {
                InputStream stdout = tc.getInputStream();
                OutputStream stdin = tc.getOutputStream();
                StringBuilder outputBuf = new StringBuilder();
                this.receive(handler, stdout, outputBuf, "ogin:");
                this.send(handler, stdin, this.username);
                this.receive(handler, stdout, outputBuf, "assword:");
                this.send(handler, stdin, this.password);
                this.receive(handler, stdout, outputBuf, ">", "ogon failure");
                this.send(handler, stdin, "PROMPT WINDOWS4DEPLOYIT ");
                this.receive(handler, stdout, outputBuf, DETECTABLE_WINDOWS_PROMPT);
                this.receive(handler, stdout, outputBuf, DETECTABLE_WINDOWS_PROMPT);
                this.send(handler, stdin, commandLineForExecution);
                this.receive(handler, stdout, outputBuf, DETECTABLE_WINDOWS_PROMPT);
                this.send(handler, stdin, "ECHO \"ERRORLEVEL-PREAMBLE%errorlevel%ERRORLEVEL-POSTAMBLE");
                this.receive(handler, stdout, outputBuf, ERRORLEVEL_POSTAMBLE);
                this.receive(handler, stdout, outputBuf, ERRORLEVEL_POSTAMBLE);
                int preamblePos = outputBuf.indexOf(ERRORLEVEL_PREAMBLE);
                int postamblePos = outputBuf.indexOf(ERRORLEVEL_POSTAMBLE);
                if (preamblePos >= 0 && postamblePos >= 0) {
                    String errorlevelString = outputBuf.substring(preamblePos + ERRORLEVEL_PREAMBLE.length(), postamblePos);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Errorlevel string found: " + errorlevelString);
                    }
                    try {
                        int n = Integer.parseInt(errorlevelString);
                        return n;
                    }
                    catch (NumberFormatException exc) {
                        logger.error("Cannot parse errorlevel in Windows output: " + outputBuf);
                        int n = -999999;
                        tc.disconnect();
                        return n;
                    }
                }
                logger.error("Cannot find errorlevel in Windows output: " + outputBuf);
                int n = -999999;
                return n;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                tc.disconnect();
            }
        }
        catch (InvalidTelnetOptionException exc) {
            throw new RuntimeIOException("Cannot execute command " + commandLineForLogging + " on " + this.address, exc);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + commandLineForLogging + " on " + this.address, exc);
        }
    }

    @Override
    public CommandExecution startExecute(CmdLine command) {
        final String commandLineForExecution = this.encodeCommandLineForExecution(command);
        final String commandLineForLogging = this.encodeCommandLineForLogging(command);
        final CapturingCommandExecutionCallbackHandler handler = new CapturingCommandExecutionCallbackHandler();
        return new CommandExecution(){
            TelnetClient tc;
            InputStream stdout;
            OutputStream stdin;
            StringBuilder outputBuf;
            {
                try {
                    this.tc = new TelnetClient();
                    this.tc.setConnectTimeout(120000);
                    this.tc.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(299, 25, true, false, true, false));
                    this.tc.connect(CifsTelnetHostSession.this.address);
                    this.stdout = this.tc.getInputStream();
                    this.stdin = this.tc.getOutputStream();
                    this.outputBuf = new StringBuilder();
                    CifsTelnetHostSession.this.receive(handler, this.stdout, this.outputBuf, "ogin:");
                    CifsTelnetHostSession.this.send(handler, this.stdin, CifsTelnetHostSession.this.username);
                    CifsTelnetHostSession.this.receive(handler, this.stdout, this.outputBuf, "assword:");
                    CifsTelnetHostSession.this.send(handler, this.stdin, CifsTelnetHostSession.this.password);
                    CifsTelnetHostSession.this.receive(handler, this.stdout, this.outputBuf, ">", "ogon failure");
                    CifsTelnetHostSession.this.send(handler, this.stdin, "PROMPT WINDOWS4DEPLOYIT ");
                    CifsTelnetHostSession.this.receive(handler, this.stdout, this.outputBuf, CifsTelnetHostSession.DETECTABLE_WINDOWS_PROMPT);
                    CifsTelnetHostSession.this.receive(handler, this.stdout, this.outputBuf, CifsTelnetHostSession.DETECTABLE_WINDOWS_PROMPT);
                    CifsTelnetHostSession.this.send(handler, this.stdin, commandLineForExecution);
                }
                catch (InvalidTelnetOptionException exc) {
                    throw new RuntimeIOException("Cannot execute command " + commandLineForLogging + " on " + CifsTelnetHostSession.this.address, exc);
                }
                catch (IOException exc) {
                    throw new RuntimeIOException("Cannot execute command " + commandLineForLogging + " on " + CifsTelnetHostSession.this.address, exc);
                }
            }

            @Override
            public OutputStream getStdin() {
                return this.stdin;
            }

            @Override
            public InputStream getStdout() {
                return this.stdout;
            }

            @Override
            public InputStream getStderr() {
                return new ByteArrayInputStream(new byte[0]);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive exception aggregation
             */
            @Override
            public int waitFor() {
                try {
                    try {
                        CifsTelnetHostSession.this.receive(handler, this.stdout, this.outputBuf, CifsTelnetHostSession.DETECTABLE_WINDOWS_PROMPT);
                        CifsTelnetHostSession.this.send(handler, this.stdin, "ECHO \"ERRORLEVEL-PREAMBLE%errorlevel%ERRORLEVEL-POSTAMBLE");
                        CifsTelnetHostSession.this.receive(handler, this.stdout, this.outputBuf, CifsTelnetHostSession.ERRORLEVEL_POSTAMBLE);
                        CifsTelnetHostSession.this.receive(handler, this.stdout, this.outputBuf, CifsTelnetHostSession.ERRORLEVEL_POSTAMBLE);
                        int preamblePos = this.outputBuf.indexOf(CifsTelnetHostSession.ERRORLEVEL_PREAMBLE);
                        int postamblePos = this.outputBuf.indexOf(CifsTelnetHostSession.ERRORLEVEL_POSTAMBLE);
                        if (preamblePos >= 0 && postamblePos >= 0) {
                            String errorlevelString = this.outputBuf.substring(preamblePos + CifsTelnetHostSession.ERRORLEVEL_PREAMBLE.length(), postamblePos);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Errorlevel string found: " + errorlevelString);
                            }
                            try {
                                int n = Integer.parseInt(errorlevelString);
                                return n;
                            }
                            catch (NumberFormatException exc) {
                                logger.error("Cannot parse errorlevel in Windows output: " + this.outputBuf);
                                int n = -999999;
                                this.tc.disconnect();
                                return n;
                            }
                        }
                        logger.error("Cannot find errorlevel in Windows output: " + this.outputBuf);
                        int n = -999999;
                        return n;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        this.tc.disconnect();
                    }
                }
                catch (IOException exc) {
                    throw new RuntimeIOException("Cannot execute command " + commandLineForLogging + " on " + CifsTelnetHostSession.this.address, exc);
                }
            }
        };
    }

    private void receive(CommandExecutionCallbackHandler handler, InputStream stdout, StringBuilder outputBuf, String expectedString) throws IOException {
        this.receive(handler, stdout, outputBuf, expectedString, null);
    }

    private void receive(CommandExecutionCallbackHandler handler, InputStream stdout, StringBuilder outputBuf, String expectedString, String unexpectedString) throws IOException {
        String s;
        boolean lastCharWasCr = false;
        boolean lastCharWasEsc = false;
        do {
            int c;
            if ((c = stdout.read()) == -1) {
                throw new IOException("End of stream reached");
            }
            handler.handleOutput((char)c);
            switch ((char)c) {
                case '\r': {
                    handler.handleOutputLine(outputBuf.toString());
                    outputBuf.delete(0, outputBuf.length());
                    break;
                }
                case '\n': {
                    if (lastCharWasCr) break;
                    handler.handleOutputLine(outputBuf.toString());
                    outputBuf.delete(0, outputBuf.length());
                    break;
                }
                case '[': {
                    if (lastCharWasEsc) {
                        throw new RuntimeIOException("VT100/ANSI escape sequence found in output stream. Please configure the Windows Telnet server to use stream mode (tlntadmn config mode=stream).");
                    }
                }
                default: {
                    outputBuf.append((char)c);
                }
            }
            lastCharWasCr = c == 13;
            boolean bl = lastCharWasEsc = c == 27;
            if (unexpectedString == null || outputBuf.length() < unexpectedString.length() || !(s = outputBuf.substring(outputBuf.length() - unexpectedString.length(), outputBuf.length())).equals(unexpectedString)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Unexpected string \"" + unexpectedString + "\" found in Windows Telnet output");
            }
            throw new IOException("Unexpected string \"" + unexpectedString + "\" found in Windows Telnet output");
        } while (outputBuf.length() < expectedString.length() || !(s = outputBuf.substring(outputBuf.length() - expectedString.length(), outputBuf.length())).equals(expectedString));
        if (logger.isDebugEnabled()) {
            logger.debug("Expected string \"" + expectedString + "\" found in Windows Telnet output");
        }
    }

    private void send(CommandExecutionCallbackHandler handler, OutputStream stdin, String lineToSend) throws IOException {
        byte[] bytesToSend = (lineToSend + "\r\n").getBytes();
        stdin.write(bytesToSend);
        stdin.flush();
    }

    @Override
    public HostFile getFile(String hostPath) throws RuntimeIOException {
        try {
            SmbFile smbFile = new SmbFile(this.encodeAsSmbUrl(hostPath));
            return new CifsHostFile(this, smbFile);
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    @Override
    public HostFile getFile(HostFile parent, String child) throws RuntimeIOException {
        return this.getFile(parent.getPath() + this.getHostOperatingSystem().getFileSeparator() + child.replace('\\', '/'));
    }

    @Override
    public HostFile getTempFile(String prefix, String suffix) throws RuntimeIOException {
        Preconditions.checkNotNull((Object)prefix);
        if (suffix == null) {
            suffix = ".tmp";
        }
        Random r = new Random();
        String infix = "";
        int i = 0;
        while ((long)i < 100L) {
            HostFile f = this.getFile(this.getTemporaryDirectory().getPath() + this.getHostOperatingSystem().getFileSeparator() + prefix + infix + suffix);
            if (!f.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Created temporary file " + f);
                }
                return f;
            }
            infix = "-" + Long.toString(Math.abs(r.nextLong()));
            ++i;
        }
        throw new RuntimeIOException("Cannot generate a unique temporary file name on " + this);
    }

    private String encodeAsSmbUrl(String hostPath) {
        StringBuffer smbUrl = new StringBuffer();
        smbUrl.append("smb://");
        smbUrl.append(CifsTelnetHostSession.urlEncode(this.username.replaceFirst("\\\\", ";")));
        smbUrl.append(":");
        smbUrl.append(CifsTelnetHostSession.urlEncode(this.password));
        smbUrl.append("@");
        smbUrl.append(CifsTelnetHostSession.urlEncode(this.address));
        smbUrl.append("/");
        if (hostPath.length() < 2) {
            throw new RuntimeIOException("Host path \"" + hostPath + "\" is too short");
        }
        if (hostPath.charAt(1) != ':') {
            throw new RuntimeIOException("Host path \"" + hostPath + "\" does not have a colon (:) as its second character");
        }
        smbUrl.append(hostPath.charAt(0));
        smbUrl.append("$/");
        if (hostPath.length() >= 3) {
            if (hostPath.charAt(2) != '\\') {
                throw new RuntimeIOException("Host path \"" + hostPath + "\" does not have a backslash (\\) as its third character");
            }
            smbUrl.append(hostPath.substring(3).replace('\\', '/'));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Encoded Windows host path \"" + hostPath + "\" to SMB URL \"" + smbUrl.toString() + "\"");
        }
        return smbUrl.toString();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeIOException("Unable to construct SMB URL", e);
        }
    }

    public String toString() {
        return this.username + "@" + this.address;
    }
}

