/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.common;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.common.HostFileDirectoryWalker;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostFileCopier
extends HostFileDirectoryWalker {
    private static final String SOURCE = "Source";
    private static final String DESTINATION = "Destination";
    private Stack<HostFile> dstDirStack = new Stack();
    private HostFile srcDir;
    private HostFileInputStreamTransformer transformer;
    private static Logger logger = LoggerFactory.getLogger(HostFileCopier.class);

    private HostFileCopier(HostFile srcDir, HostFile dstDir, HostFileInputStreamTransformer transformer) {
        this.dstDirStack.push(dstDir);
        this.srcDir = srcDir;
        HostFileCopier.checkDirectoryExists(srcDir, SOURCE);
        this.transformer = transformer;
    }

    @Override
    protected void handleDirectoryStart(HostFile scrDir, int depth) throws IOException {
        HostFile dstDir = this.getCurrentDestinationDir();
        if (depth != 0) {
            dstDir = this.createSubdirectoryAndMakeCurrent(dstDir, scrDir.getName());
        }
        if (dstDir.exists()) {
            HostFileCopier.checkReallyIsADirectory(dstDir, DESTINATION);
            if (logger.isDebugEnabled()) {
                logger.debug("About to copy files into existing directory " + dstDir);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating destination directory " + dstDir);
            }
            dstDir.mkdir();
        }
    }

    private HostFile createSubdirectoryAndMakeCurrent(HostFile parentDir, String subdirName) {
        HostFile subdir = parentDir.getFile(subdirName);
        this.dstDirStack.push(subdir);
        return subdir;
    }

    private void startCopy() {
        this.walk(this.srcDir);
    }

    private HostFile getCurrentDestinationDir() {
        return this.dstDirStack.peek();
    }

    @Override
    protected void handleFile(HostFile srcFile, int depth) throws IOException {
        HostFile dstFile = this.getCurrentDestinationDir().getFile(srcFile.getName());
        HostFileCopier.copyFile(srcFile, dstFile, this.transformer);
    }

    @Override
    protected void handleDirectoryEnd(HostFile directory, int depth) throws IOException {
        if (depth != 0) {
            this.dstDirStack.pop();
        }
    }

    public static void copy(HostFile src, HostFile dst, HostFileInputStreamTransformer transformer) {
        if (src.isDirectory()) {
            HostFileCopier.copyDirectory(src, dst, transformer);
        } else {
            HostFileCopier.copyFile(src, dst, transformer);
        }
    }

    public static void copyDirectory(HostFile srcDir, HostFile dstDir, HostFileInputStreamTransformer transformer) throws RuntimeIOException {
        HostFileCopier dirCopier = new HostFileCopier(srcDir, dstDir, transformer);
        dirCopier.startCopy();
    }

    public static void copyFile(HostFile srcFile, HostFile dstFile, HostFileInputStreamTransformer transformer) throws RuntimeIOException {
        HostFileCopier.checkFileExists(srcFile, SOURCE);
        HostFileCopier.checkReallyIsAFile(dstFile, DESTINATION);
        if (logger.isDebugEnabled()) {
            if (dstFile.exists()) {
                logger.debug("About to overwrite existing file " + dstFile);
            }
            logger.debug("Copying contents of file " + srcFile + " to " + dstFile);
        }
        HostFileCopier.copyStreamToFile(HostFileCopier.transform(srcFile, transformer), dstFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStreamToFile(HostFileInputStreamTransformer.TransformedInputStream in, HostFile dstFile) {
        try {
            dstFile.put(in, in.length());
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static HostFileInputStreamTransformer.TransformedInputStream transform(HostFile file, HostFileInputStreamTransformer transformer) {
        if (transformer == null) {
            return new HostFileInputStreamTransformer.TransformedInputStream(file.get(), file.length());
        }
        return transformer.transform(file);
    }

    public static void checkFileExists(HostFile file, String sourceDescription) {
        if (!file.exists()) {
            throw new RuntimeIOException(sourceDescription + " file " + file + " does not exist");
        }
        HostFileCopier.checkReallyIsAFile(file, sourceDescription);
    }

    public static void checkReallyIsAFile(HostFile file, String fileDescription) {
        if (file.exists() && file.isDirectory()) {
            throw new RuntimeIOException(fileDescription + " file " + file + " exists but is a directory");
        }
    }

    public static void checkDirectoryExists(HostFile dir, String dirDescription) {
        if (!dir.exists()) {
            throw new RuntimeIOException(dirDescription + " directory " + dir + " does not exist");
        }
        HostFileCopier.checkReallyIsADirectory(dir, dirDescription);
    }

    public static void checkReallyIsADirectory(HostFile dir, String dirDescription) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new RuntimeIOException(dirDescription + " directory " + dir + " exists but is not a directory");
        }
    }
}

