/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.mapper;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.qrmedia.commons.lang.ClassUtils;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.ci.mapping.SourcePropertyOverridingMapping;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public abstract class Mapper<S extends Serializable, M extends Mapping<? super S, ? super T>, T extends Serializable> {
    protected Change<Deployment> change;
    protected List<M> oldMappings;
    protected List<M> newMappings;
    protected List<M> addedMappings;
    protected List<Pair<M, M>> modifiedMappings;
    protected List<M> deletedMappings;
    private Class<S> sourceCiClass;
    private Class<M> mappingCiClass;
    private Class<T> targetCiClass;
    private boolean applyDefaultMappings;
    private HashSet<T> affectedTargets;
    protected Function<Pair<M, M>, M> FIRST_MAPPING = new Function<Pair<M, M>, M>(){

        public M apply(Pair<M, M> from) {
            return (Mapping)from.getFirst();
        }
    };
    protected Function<Pair<M, M>, M> SECOND_MAPPING = new Function<Pair<M, M>, M>(){

        public M apply(Pair<M, M> from) {
            return (Mapping)from.getSecond();
        }
    };

    protected Mapper(Change<Deployment> change, boolean applyDefaultMappings) {
        this.change = change;
        this.applyDefaultMappings = applyDefaultMappings;
        List actualTypeArguments = ClassUtils.getActualTypeArguments(this.getClass(), Mapper.class);
        if (actualTypeArguments.size() != 3) {
            throw new IllegalArgumentException("Not exactly three parametrized types?");
        }
        this.sourceCiClass = (Class)Preconditions.checkNotNull(actualTypeArguments.get(0));
        this.mappingCiClass = (Class)Preconditions.checkNotNull(actualTypeArguments.get(1));
        this.targetCiClass = (Class)Preconditions.checkNotNull(actualTypeArguments.get(2));
        this.init();
    }

    protected Mapper(Change<Deployment> change) {
        this(change, false);
    }

    protected void init() {
        this.oldMappings = this.calculateMappings(this.change.getOldRevision());
        this.newMappings = this.calculateMappings(this.change.getNewRevision());
        this.addedMappings = this.substractSimilarMappings(this.newMappings, this.oldMappings);
        this.modifiedMappings = this.findModifiedMappings(this.oldMappings, this.newMappings);
        this.deletedMappings = this.substractSimilarMappings(this.oldMappings, this.newMappings);
    }

    public List<M> getOldMappings() {
        return this.oldMappings;
    }

    public List<M> getNewMappings() {
        return this.newMappings;
    }

    public List<M> getAddedMappings() {
        return this.addedMappings;
    }

    public List<Pair<M, M>> getModifiedMappings() {
        return this.modifiedMappings;
    }

    public List<M> getDeletedMappings() {
        return this.deletedMappings;
    }

    public Set<T> getAllTargets() {
        HashSet allTargets = new HashSet();
        this.gatherTargets(this.oldMappings, allTargets);
        this.gatherTargets(this.newMappings, allTargets);
        return allTargets;
    }

    public Set<T> getAffectedTargets() {
        this.affectedTargets = new HashSet();
        this.gatherTargets(this.addedMappings, this.affectedTargets);
        this.gatherTargets(this.deletedMappings, this.affectedTargets);
        for (Pair<M, M> mPair : this.modifiedMappings) {
            this.affectedTargets.add(((Mapping)mPair.getFirst()).getTarget());
            this.affectedTargets.add(((Mapping)mPair.getSecond()).getTarget());
        }
        return this.affectedTargets;
    }

    public Set<T> getOldTargets() {
        HashSet targets = new HashSet();
        this.gatherTargets(this.oldMappings, targets);
        return targets;
    }

    public Set<T> getNewTargets() {
        HashSet targets = new HashSet();
        this.gatherTargets(this.newMappings, targets);
        return targets;
    }

    private void gatherTargets(Collection<M> mappings, Set<T> targetsCollector) {
        for (Mapping m : mappings) {
            targetsCollector.add(m.getTarget());
        }
    }

    public void setDefaults(Deployment deployment, M newDefaultMapping) {
    }

    private List<M> calculateMappings(Deployment deployment) {
        ArrayList mappings = new ArrayList();
        if (deployment != null) {
            Collection<S> sources = deployment.getSource().getMembersOfType(this.sourceCiClass);
            for (Serializable eachSource : sources) {
                List<Mapping> explicitMappings = deployment.getMappingsForSource(Mapping.class, eachSource);
                if (!explicitMappings.isEmpty()) {
                    this.filterExplicitMappings(mappings, explicitMappings);
                    continue;
                }
                if (!this.applyDefaultMappings) continue;
                this.generateDefaultMappingsForSource(mappings, eachSource, deployment);
            }
        }
        return mappings;
    }

    private void generateDefaultMappingsForSource(List<M> mappings, S source, Deployment deployment) {
        for (Serializable eachTarget : deployment.getTarget().getMembersOfType(this.targetCiClass)) {
            Mapping newMapping;
            try {
                newMapping = (Mapping)this.mappingCiClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            newMapping.setLabel("Default mapping from " + source + " to " + eachTarget);
            newMapping.setTarget(eachTarget);
            newMapping.setSource(source);
            this.setDefaults(deployment, newMapping);
            mappings.add(newMapping);
        }
    }

    private void filterExplicitMappings(List<M> mappings, List<? extends Mapping> explicitMappings) {
        for (Mapping mapping : explicitMappings) {
            if (!this.mappingCiClass.isInstance(mapping) || !this.targetCiClass.isInstance(mapping.getTarget())) continue;
            this.applySourcePropertyOverrides(mapping);
            mappings.add(mapping);
        }
    }

    private void applySourcePropertyOverrides(Mapping mapping) {
        if (mapping instanceof SourcePropertyOverridingMapping) {
            Serializable copyOfsourceWithPropertiesOverridden = Mapper.applyPropertyOverrides(mapping.getSource(), ((SourcePropertyOverridingMapping)mapping).getSourcePropertyOverrides());
            mapping.setSource(copyOfsourceWithPropertiesOverridden);
        }
    }

    private static Serializable applyPropertyOverrides(Serializable source, List<KeyValuePair> sourcePropertyOverrides) {
        HashMap<String, String> overrides = new HashMap<String, String>();
        if (sourcePropertyOverrides != null) {
            for (KeyValuePair override : sourcePropertyOverrides) {
                overrides.put(override.getKey(), override.getValue());
            }
        }
        try {
            return ConfigurationItemReflectionUtils.overrideProperties(source, overrides);
        }
        catch (IllegalArgumentException exception) {
            throw new ResolutionException(String.format("Invalid property override specified for %s in %s: %s", source, overrides, exception.getMessage()), exception);
        }
    }

    private List<M> substractSimilarMappings(List<M> lhs, List<M> rhs) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        for (final Mapping l : lhs) {
            if (CollectionUtils.exists(rhs, (Predicate)new Predicate(){

                public boolean evaluate(Object r) {
                    return l.isSimilar((Mapping)r);
                }
            })) continue;
            result.add(l);
        }
        return result;
    }

    private List<Pair<M, M>> findModifiedMappings(List<M> oldMappings, List<M> newMappings) {
        ArrayList<Pair<M, M>> modifiedMappings = new ArrayList<Pair<M, M>>();
        block0: for (Mapping l : oldMappings) {
            for (Mapping r : newMappings) {
                Mapping correctlyCapturedL = l;
                Mapping correctlyCapturedR = r;
                boolean mappingsAreSimilar = correctlyCapturedL.isSimilar(correctlyCapturedR);
                boolean mappingsAreIdentical = correctlyCapturedL.isIdentical(correctlyCapturedR);
                if (!mappingsAreSimilar || mappingsAreIdentical) continue;
                modifiedMappings.add(new Pair<Mapping, Mapping>(l, r));
                continue block0;
            }
        }
        return modifiedMappings;
    }
}

