/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSftpHostFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSftpHostSession
extends SshHostSession {
    private ChannelSftp sharedSftpChannel;
    private Logger logger = LoggerFactory.getLogger(SshSftpHostSession.class);

    public SshSftpHostSession(OperatingSystemFamily os, String temporaryDirectoryPath, String host, int port, String username, String password) {
        super(os, temporaryDirectoryPath, host, port, username, password);
        this.open();
    }

    public HostFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
        return new SshSftpHostFile(this, hostPath);
    }

    public void close() {
        super.close();
        if (this.sharedSftpChannel != null) {
            this.closeSftpChannel(this.sharedSftpChannel);
        }
    }

    protected ChannelSftp getSharedSftpChannel() throws JSchException {
        if (this.sharedSftpChannel == null) {
            this.sharedSftpChannel = this.openSftpChannel();
        }
        return this.sharedSftpChannel;
    }

    protected ChannelSftp openSftpChannel() throws JSchException {
        Channel channel = this.getSharedSession().openChannel("sftp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Opened SFTP channel to " + this);
        }
        channel.connect();
        return (ChannelSftp)channel;
    }

    protected void closeSftpChannel(ChannelSftp sftpChannel) {
        if (sftpChannel != null) {
            sftpChannel.disconnect();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closed SFTP channel to " + this);
            }
        }
    }

    public String toString() {
        return this.username + "@" + this.host + ":" + this.port + " (sftp)";
    }
}

