/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CmdLineArgument;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSudoHostFile;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshSudoHostSession
extends SshHostSession {
    protected String sudoUsername;
    private Logger logger = LoggerFactory.getLogger(SshSudoHostSession.class);

    public SshSudoHostSession(OperatingSystemFamily os, String temporaryDirectoryPath, String host, int port, String username, String password, String sudoUsername) {
        super(os, temporaryDirectoryPath, host, port, username, password);
        this.sudoUsername = sudoUsername;
        this.open();
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, Map<String, String> inputResponse, CmdLine commandLine) throws RuntimeIOException {
        CmdLine commandLineWithSudo = this.prependSudoCommand(commandLine);
        return super.execute(handler, inputResponse, commandLineWithSudo);
    }

    @Override
    public CommandExecution startExecute(CmdLine commandLine) {
        CmdLine commandLineWithSudo = this.prependSudoCommand(commandLine);
        return super.startExecute(commandLineWithSudo);
    }

    protected CmdLine prependSudoCommand(CmdLine cmdLine) {
        CmdLine sudoCommandLine = new CmdLine();
        this.addSudoStatement(sudoCommandLine);
        for (CmdLineArgument argument : cmdLine.getArguments()) {
            sudoCommandLine.add(argument);
            String arg = argument.toString(false);
            if (!arg.equals("|") && !arg.equals(";")) continue;
            this.addSudoStatement(sudoCommandLine);
        }
        return sudoCommandLine;
    }

    protected void addSudoStatement(CmdLine sudoCommandLineCollector) {
        sudoCommandLineCollector.addArgument("sudo");
        sudoCommandLineCollector.addArgument("-u");
        sudoCommandLineCollector.addArgument(this.sudoUsername);
    }

    protected int noSudoExecute(CommandExecutionCallbackHandler handler, CmdLine commandLine) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NOT adding sudo statement");
        }
        return super.execute(handler, (Map<String, String>)Collections.EMPTY_MAP, commandLine);
    }

    @Override
    protected HostFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
        return new SshSudoHostFile(this, hostPath, isTempFile);
    }

    @Override
    protected HostFile createSessionTempDirectory(HostFile systemTempDirectory, String name) {
        HostFile f = this.getFile(systemTempDirectory, name, true);
        if (!f.exists()) {
            f.mkdir();
            return f;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.username + "@" + this.host + ":" + this.port + " (sudo to " + this.sudoUsername + ")";
    }
}

