/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostFileUtils {
    private static final String ZIP_PATH_SEPARATOR = "/";
    private static final String TAR_PATH_SEPARATOR = "/";
    private static Logger logger = LoggerFactory.getLogger(HostFileUtils.class);

    public static void copy(HostFile src, HostFile dst) {
        HostFileUtils.copy(src, dst, null);
    }

    public static void copy(HostFile src, HostFile dst, HostFileInputStreamTransformer transformer) {
        dst.copyFrom(src, transformer);
    }

    @Deprecated
    public static void copyFile(HostFile srcFile, HostFile dstFile) throws RuntimeIOException {
        HostFileUtils.copy(srcFile, dstFile);
    }

    @Deprecated
    public static void copyFile(HostFile srcFile, HostFile dstFile, HostFileInputStreamTransformer transformer) throws RuntimeIOException {
        HostFileUtils.copy(srcFile, dstFile, transformer);
    }

    @Deprecated
    public static void copyDirectory(HostFile srcDir, HostFile dstDir) throws RuntimeIOException {
        HostFileUtils.copy(srcDir, dstDir);
    }

    @Deprecated
    public static void copyDirectory(HostFile srcDir, HostFile dstDir, HostFileInputStreamTransformer transformer) throws RuntimeIOException {
        HostFileUtils.copy(srcDir, dstDir, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putStringToHostFile(String sourceString, HostFile targetFile) {
        byte[] bytes;
        try {
            bytes = sourceString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeIOException(exc);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            targetFile.put(in, bytes.length);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostFileAsString(HostFile sourceHostFile) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            sourceHostFile.get(bos);
            String string = new String(bos.toByteArray());
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bos);
        }
    }

    public static void unzip(HostFile zip, HostFile dir) {
        HostFileUtils.unzip(zip, dir, null);
    }

    public static void unzip(HostFile zip, HostFile dir, HostFileInputStreamTransformer transformer) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        if (transformer == null) {
            HostFileUtils.unzip(zip.getPath(), zip.get(), dir);
        } else {
            HostFileUtils.unzip(zip.getPath(), transformer.transform(zip), dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(String zipPath, InputStream zipStream, HostFile dstDir) {
        if (logger.isDebugEnabled()) {
            logger.debug("Unzipping " + zipPath + " to " + dstDir);
        }
        ZipInputStream zipIn = new ZipInputStream(zipStream);
        try {
            try {
                ZipEntry entry;
                while ((entry = zipIn.getNextEntry()) != null) {
                    HostFileUtils.extractZipEntry(zipIn, entry, dstDir);
                }
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot unzip " + zipPath + " to " + dstDir, exc);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipIn);
        }
    }

    private static void extractZipEntry(ZipInputStream zipIn, ZipEntry entry, HostFile dir) {
        Object[] pathElements = StringUtils.split((String)entry.getName(), (String)"/");
        String dstFileSeparator = dir.getSession().getHostOperatingSystem().getFileSeparator();
        String dstPath = StringUtils.join((Object[])pathElements, (String)dstFileSeparator);
        HostFile dstFile = dir.getFile(dstPath);
        if (logger.isDebugEnabled()) {
            logger.debug("Unzipping " + entry.getName() + " to " + dstFile.getPath());
        }
        if (entry.isDirectory()) {
            dstFile.mkdirs();
        } else {
            dstFile.getParentFile().mkdirs();
            dstFile.put(zipIn, entry.getSize());
        }
    }

    public static void untar(HostFile tar, HostFile dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        HostFileUtils.untar(tar.getPath(), tar.get(), dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void untar(String tarPath, InputStream zipStream, HostFile dstDir) {
        if (logger.isDebugEnabled()) {
            logger.debug("Untarring " + tarPath + " to " + dstDir);
        }
        TarInputStream tarIn = new TarInputStream(zipStream);
        try {
            try {
                TarEntry entry;
                while ((entry = tarIn.getNextEntry()) != null) {
                    HostFileUtils.extractTarEntry(tarIn, entry, dstDir);
                }
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot untar " + tarPath + " to " + dstDir, exc);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)tarIn);
        }
    }

    private static void extractTarEntry(TarInputStream tarInputStream, TarEntry entry, HostFile dir) {
        Object[] pathElements = StringUtils.split((String)entry.getName(), (String)"/");
        String dstFileSeparator = dir.getSession().getHostOperatingSystem().getFileSeparator();
        String dstPath = StringUtils.join((Object[])pathElements, (String)dstFileSeparator);
        HostFile dstFile = dir.getFile(dstPath);
        if (logger.isDebugEnabled()) {
            logger.debug("Untarring " + entry.getName() + " to " + dstFile.getPath());
        }
        if (entry.isDirectory()) {
            dstFile.mkdirs();
        } else {
            dstFile.getParentFile().mkdirs();
            dstFile.put((InputStream)tarInputStream, entry.getSize());
        }
    }
}

