/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.mapping;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import java.io.Serializable;

public abstract class Mapping<S extends Serializable, T extends Serializable>
extends BaseConfigurationItem {
    @ConfigurationItemProperty(required=true)
    private S source;
    @ConfigurationItemProperty(required=true, asContainment=true)
    private T target;

    public Mapping() {
    }

    public Mapping(S source, T target) {
        this.label = "Mapping from " + source + " to " + target;
        this.source = source;
        this.target = target;
    }

    public S getSource() {
        return this.source;
    }

    public void setSource(S source) {
        this.source = source;
    }

    public T getTarget() {
        return this.target;
    }

    public void setTarget(T target) {
        this.target = target;
    }

    public void postInit(Deployment deployment) {
    }

    public boolean isSimilar(Mapping<S, T> that) {
        boolean sourcesAreSimilar = ConfigurationItemReflectionUtils.isSimilar(this.getSource(), that.getSource());
        boolean targetsAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this.getTarget(), that.getTarget());
        return sourcesAreSimilar && targetsAreIdentical;
    }

    public boolean isIdentical(Mapping<S, T> that) {
        boolean sourcesAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this.getSource(), that.getSource());
        boolean mappingsAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this, that);
        boolean targetsAreIdentical = ConfigurationItemReflectionUtils.isIdentical(this.getTarget(), that.getTarget());
        return sourcesAreIdentical && mappingsAreIdentical && targetsAreIdentical;
    }
}

