/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.common.AbstractHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;

abstract class SshHostFile
extends AbstractHostFile {
    protected SshHostSession sshHostSession;
    protected String remotePath;

    SshHostFile(SshHostSession session, String remotePath) {
        super(session);
        this.sshHostSession = session;
        this.remotePath = remotePath;
    }

    @Override
    public String getPath() {
        return this.remotePath;
    }

    @Override
    public String getName() {
        String fileSep = this.sshHostSession.getHostOperatingSystem().getFileSeparator();
        int lastFileSepPos = this.remotePath.lastIndexOf(fileSep);
        if (lastFileSepPos < 0) {
            return this.remotePath;
        }
        return this.remotePath.substring(lastFileSepPos + 1);
    }

    @Override
    public String getParent() {
        String fileSep = this.sshHostSession.getHostOperatingSystem().getFileSeparator();
        int lastFileSepPos = this.remotePath.lastIndexOf(fileSep);
        if (lastFileSepPos < 0 || this.remotePath.equals(fileSep)) {
            return "";
        }
        if (lastFileSepPos == 0) {
            return fileSep;
        }
        return this.remotePath.substring(0, lastFileSepPos);
    }

    @Override
    public boolean delete() throws RuntimeIOException {
        if (!this.exists()) {
            return false;
        }
        if (this.isDirectory()) {
            this.deleteDirectory();
            return true;
        }
        this.deleteFile();
        return true;
    }

    @Override
    protected int executeCommand(CommandExecutionCallbackHandler handler, CmdLine command) {
        return this.sshHostSession.execute(handler, command);
    }

    protected abstract void deleteFile();

    protected abstract void deleteDirectory();

    public String toString() {
        return this.getPath() + " on " + this.sshHostSession;
    }
}

