/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CmdLine;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshScpHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshSudoHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshSudoOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoHostFile
extends SshScpHostFile
implements HostFile {
    private SshSudoHostSession sshSudoHostSession;
    private boolean isTempFile;
    private Logger logger = LoggerFactory.getLogger(SshSudoHostFile.class);

    public SshSudoHostFile(SshSudoHostSession session, String remotePath, boolean isTempFile) {
        super(session, remotePath);
        this.sshSudoHostSession = session;
        this.isTempFile = isTempFile;
    }

    @Override
    protected int executeCommand(CommandExecutionCallbackHandler handler, CmdLine command) {
        if (this.isTempFile) {
            return this.sshSudoHostSession.noSudoExecute(handler, command);
        }
        return super.executeCommand(handler, command);
    }

    @Override
    public HostFile getFile(String name) {
        SshSudoHostFile f = (SshSudoHostFile)super.getFile(name);
        f.isTempFile = this.isTempFile;
        return f;
    }

    @Override
    public HostFile getParentFile() {
        SshSudoHostFile f = (SshSudoHostFile)super.getParentFile();
        f.isTempFile = this.isTempFile;
        return f;
    }

    @Override
    public InputStream get() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.get();
        }
        SshScpHostFile tempFile = this.getTempFile();
        this.copyHostFileToTempFile(tempFile);
        this.grantReadWritePermissionToGroupAndOthers(tempFile, false);
        return tempFile.get();
    }

    private void copyHostFileToTempFile(HostFile tempFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Copying " + this + " to " + tempFile + " for reading");
        }
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int result = this.session.execute((CommandExecutionCallbackHandler)capturedOutput, "cp", this.getPath(), tempFile.getPath());
        if (result != 0) {
            String errorMessage = capturedOutput.getAll();
            throw new RuntimeIOException("Cannot copy " + this + " to " + tempFile + " for reading: " + errorMessage);
        }
    }

    @Override
    public OutputStream put(long length) throws RuntimeIOException {
        if (this.isTempFile) {
            return super.put(length);
        }
        SshSudoOutputStream out = new SshSudoOutputStream(this, length, this.getTempFile());
        out.open();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Opened SUDO output stream to remote file " + this);
        }
        return out;
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        if (this.isTempFile) {
            this.logger.debug("Making directory world-writable (with sticky bit)");
            this.mkdir(new String[]{"-m", "1777"});
        } else {
            super.mkdir();
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        if (this.isTempFile) {
            this.logger.debug("Making directory world-writable (with sticky bit)");
            this.mkdir(new String[]{"-p", "-m", "1777"});
        } else {
            super.mkdirs();
        }
    }

    @Override
    protected void doPostProcessingOfCopiedTempDirectory(SshScpHostFile tempDir) {
        this.grantReadWritePermissionToGroupAndOthers(tempDir, true);
    }

    private void grantReadWritePermissionToGroupAndOthers(SshScpHostFile tempFile, boolean executeAsNonSudo) {
        SshSudoHostSession sshSudoHostSession = (SshSudoHostSession)tempFile.sshHostSession;
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        CmdLine chmod = new CmdLine().addArgument("chmod").addArgument("-R").addArgument("go+Xrw").addArgument(tempFile.remotePath);
        int errno = executeAsNonSudo ? sshSudoHostSession.noSudoExecute(capturedOutput, chmod) : sshSudoHostSession.execute((CommandExecutionCallbackHandler)capturedOutput, chmod);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot chmod file " + tempFile + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Chmodded file " + tempFile);
        }
    }
}

