/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.dictionary;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.ci.Application;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.plugin.dictionary.AutoFiller;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactAutoFiller
extends AutoFiller {
    public static final String PREFIX = "placeholder";
    public static final String ALL_APPS = "*";
    private final String prefix;
    private static Logger logger = Logger.getLogger(ArtifactAutoFiller.class);

    public ArtifactAutoFiller(Deployment deployment, String type) {
        super(deployment);
        this.prefix = String.format("%s.%s.", PREFIX, type);
    }

    @Override
    public void process(List<KeyValuePair> keyValuePairs) {
        if (!keyValuePairs.isEmpty()) {
            logger.debug((Object)("key value pair are not empty " + keyValuePairs + ", return"));
        }
        Map<String, String> flattenKeyValuePairs = this.getAvailableDictionary(this.deployment);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("available key value pair: " + flattenKeyValuePairs));
        }
        for (String key : this.getKeys(flattenKeyValuePairs, this.deployment.getSource().getApplication())) {
            keyValuePairs.add(new KeyValuePair(key.substring(this.prefix.length()), null));
        }
        super.process(keyValuePairs);
    }

    private Set<String> getKeys(Map<String, String> flattenKeyValuePairs, Application application) {
        final String appName = StringUtils.substringAfterLast((String)application.getLabel(), (String)"/");
        return Maps.filterEntries(flattenKeyValuePairs, (Predicate)new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> input) {
                return this.isKey(input) && this.isValue(input, appName);
            }

            private boolean isKey(Map.Entry<String, String> input) {
                return input.getKey().startsWith(ArtifactAutoFiller.this.prefix);
            }

            private boolean isValue(Map.Entry<String, String> input, String appName2) {
                String value = input.getValue();
                if (StringUtils.isBlank((String)value)) {
                    return false;
                }
                if (value.equals(ArtifactAutoFiller.ALL_APPS)) {
                    return true;
                }
                for (String split : StringUtils.split((String)value, (String)",")) {
                    if (!appName2.equals(split)) continue;
                    return true;
                }
                return false;
            }
        }).keySet();
    }
}

