/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.steps;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.steps.TargetContainerHelper$;
import com.xebialabs.deployit.plugin.steps.TargetHostSupport;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class TargetHostSupport$class {
    public static OverthereConnection remoteConnection(TargetHostSupport $this) {
        return (OverthereConnection)Option$.MODULE$.apply((Object)$this.targetHost()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final OverthereConnection apply(Host x$1) {
                return x$1.getConnection();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("targetHost is not set");
            }
        });
    }

    public static StepExitCode execute(TargetHostSupport $this, ExecutionContext ctx) {
        try {
            return $this.executeOnTargetHost(ctx);
        }
        finally {
            $this.remoteConnection().close();
        }
    }

    public static void calculateTargetHost(TargetHostSupport $this, StepPostConstructContext ctx) {
        if ($this.targetHost() == null) {
            $this.targetHost_$eq((Host)Option$.MODULE$.apply(TargetContainerHelper$.MODULE$.defaultTargetContainer(ctx, ClassTag$.MODULE$.apply(HostContainer.class))).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Host apply(HostContainer x$2) {
                    return x$2.getHost();
                }
            }).getOrElse((Function0)new Serializable($this, ctx){
                public static final long serialVersionUID = 0L;
                private final StepPostConstructContext ctx$1;

                public final Host apply() {
                    return (Host)TargetContainerHelper$.MODULE$.targetByProperty(this.ctx$1, "host", ClassTag$.MODULE$.apply(Host.class));
                }
                {
                    this.ctx$1 = ctx$1;
                }
            }));
        }
    }

    public static OperatingSystemFamily targetOs(TargetHostSupport $this) {
        return $this.targetHost().getOs();
    }

    /*
     * WARNING - void declaration
     */
    public static OverthereFile workingDir(TargetHostSupport $this) {
        void var1_1;
        OverthereFile tmpDir = $this.remoteTempFile("working.directory.tmp");
        tmpDir.mkdir();
        $this.remoteConnection().setWorkingDirectory(tmpDir);
        return var1_1;
    }

    public static OverthereFile remoteFile(TargetHostSupport $this, String path) {
        return $this.remoteConnection().getFile(path);
    }

    public static OverthereFile remoteTempFile(TargetHostSupport $this, String fileName) {
        return $this.remoteFile($this.remoteConnection().getTempFile(fileName).getPath());
    }

    public static OverthereFile fileInWorkDir(TargetHostSupport $this, String fileName) {
        return $this.workingDir().getFile(fileName);
    }

    public static StepExitCode executeCommand(TargetHostSupport $this, CmdLine command, ExecutionContext executionContext) {
        DefaultExecutionOutputHandler stdoutHandler = DefaultExecutionOutputHandler.handleStdout((ExecutionContext)executionContext);
        DefaultExecutionOutputHandler stderrHandler = DefaultExecutionOutputHandler.handleStderr((ExecutionContext)executionContext);
        try {
            StepExitCode stepExitCode;
            executionContext.logOutput(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executing ", " on host ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command.toCommandLine($this.targetOs(), true), $this.targetHost()})));
            int exitCode = $this.remoteConnection().execute((OverthereExecutionOutputHandler)stdoutHandler, (OverthereExecutionOutputHandler)stderrHandler, command);
            if (exitCode != 0) {
                executionContext.logError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Execution failed with exit code ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)exitCode)})));
                stepExitCode = StepExitCode.FAIL;
            } else {
                stepExitCode = StepExitCode.SUCCESS;
            }
            return stepExitCode;
        }
        finally {
            stderrHandler.close();
            stdoutHandler.close();
        }
    }

    public static void $init$(TargetHostSupport $this) {
    }
}

