package com.xebialabs.deployit.plugin.steps

import java.io.StringWriter
import java.util.{HashMap => JHashMap, Map => JMap}

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext
import com.xebialabs.deployit.plugin.api.rules.{StepParameter, StepPostConstructContext}
import com.xebialabs.deployit.plugin.freemarker.ConfigurationHolder
import com.xebialabs.overthere.OverthereFile



trait FreemarkerSupport {

  @StepParameter(description = "Dictionary that contains all values available in the template", required = false, calculated = true)
  private[steps] var freemarkerContext: JMap[String, Any] = new JHashMap[String, Any]()

  private[steps] def calculateFreemarkerContext(ctx: StepPostConstructContext) {
    freemarkerContext = ContextHelper.defaultContext(ctx, freemarkerContext)
  }

  private[steps] def processWithFreemarker(templateResource: String, maskPassword: Boolean): String = {
    val writer: StringWriter = new StringWriter()
    ConfigurationHolder.configuration(maskPassword).getTemplate(templateResource).process(freemarkerContext, writer)
    writer.toString
  }

  private[steps] def renderFreemarkerTo(templateResource: String, destination: OverthereFile)(implicit ctx: ExecutionContext): Unit = {
    val out = destination.getOutputStream
    try {
      ctx.logOutput(s"Processing freemarker template $templateResource to ${destination.getPath}")
      out.write(processWithFreemarker(templateResource, maskPassword = false).getBytes)
    } finally {
      out.close()
    }
  }
}
