package com.xebialabs.deployit.plugin.steps

import java.util

import com.xebialabs.deployit.plugin.api.flow._
import com.xebialabs.deployit.plugin.api.rules.{RulePostConstruct, StepMetadata, StepParameter, StepPostConstructContext}
import com.xebialabs.deployit.plugin.overthere.Host
import com.xebialabs.xlplatform.satellite.{Satellite, SatelliteAware}

@StepMetadata(name = "template")
class TemplateStep(tmplPath: String, pathOnHost: String, host: Host, context: util.Map[String, Any] = new util.HashMap[String, Any](), createPath: Boolean = true)
  extends BaseStep with CopyFileSupport with TargetHostSupport with FreemarkerSupport with PreviewStep with SatelliteAware {

  def this() = this(null, null, null)

  targetHost = host
  freemarkerContext = context
  targetPath = pathOnHost
  createTargetPath = createPath

  @StepParameter(description = "Full path on the target host where the artifact is copied")
  private[steps] var targetPath: String = _

  @StepParameter(description = "Whether to create the target folder structure if not present. Defaults to true", required = false)
  private[steps] var createTargetPath: Boolean = _

  @StepParameter(description = "Path of the template relative to the ext/ directory")
  private val templatePath: String = tmplPath


  @RulePostConstruct
  protected def postConstruct(ctx: StepPostConstructContext) {
    calculateOrder(ctx)
    calculateDescription(ctx)
    calculateTargetHost(ctx)
    calculateFreemarkerContext(ctx)
  }

  override protected[steps] def executeOnTargetHost(implicit ctx: ExecutionContext, targetHostEnvironment: HostEnvironment): StepExitCode = {
    try {
      mkTargetDirsIfRequired(targetPath, createTargetPath)
      deleteTargetFileIfPresent(targetPath)
      val processedTemplate = remoteTempFile("freemarker-result.tmp")
      renderFreemarkerTo(templatePath, processedTemplate)
      copyFileToTarget(processedTemplate, targetPath)
      StepExitCode.SUCCESS
    } catch {
      case ExitStep => StepExitCode.FAIL
    }
  }

  override def getSatellite: Satellite = {
    targetHost.getSatellite
  }

  override lazy val getPreview: Preview = Preview.withSourcePathAndContents(
    templatePath, processWithFreemarker(templatePath, maskPassword = true))
}
