package com.xebialabs.deployit.plugin.cloud.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.Environment;

@SuppressWarnings("serial")
public class DeleteCloudEnvironmentStep implements Step {

    private Environment environment;

    public DeleteCloudEnvironmentStep(final Environment environment) {
        this.environment = environment;
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER;
    }

    @Override
    public String getDescription() {
        return "Delete dynamic environment " + environment.getId() + " from repository";
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {

        ctx.getRepository().delete(environment.getId());

        for (ConfigurationItem ci : environment.getLinkedCis()) {
            ctx.getRepository().delete(ci.getId());
        }

        return StepExitCode.SUCCESS;
    }
}
