/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.step.rule.NullCheck;
import com.xebialabs.deployit.plugin.cloud.step.rule.ResultCheck;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;
import java.util.HashMap;
import java.util.List;

public class ValidateDescriptorStep
implements Step {
    private InstanceDescriptorResolver descriptorResolver;
    private CiParser ciParser;
    private String descriptorTemplate;
    private HashMap<Object, Object> scope;
    private ResultCheck resultCheck;

    public ValidateDescriptorStep(InstanceDescriptorResolver descriptorResolver, CiParser ciParser, HashMap<Object, Object> scope, String descriptorTemplate) {
        this(descriptorResolver, ciParser, scope, descriptorTemplate, new NullCheck());
    }

    public ValidateDescriptorStep(InstanceDescriptorResolver descriptorResolver, CiParser ciParser, HashMap<Object, Object> scope, String descriptorTemplate, ResultCheck resultCheck) {
        this.descriptorResolver = descriptorResolver;
        this.ciParser = ciParser;
        this.descriptorTemplate = descriptorTemplate;
        this.scope = scope;
        this.resultCheck = resultCheck;
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Validate XML descriptor";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        String descriptor;
        try {
            descriptor = this.descriptorResolver.resolve(this.descriptorTemplate, this.scope);
            ctx.logOutput("Successfully processed descriptor template...");
            ctx.logOutput("-------------------------------------------");
            ctx.logOutput(descriptor);
            ctx.logOutput("-------------------------------------------");
        }
        catch (Exception e) {
            ctx.logError("Can not process descriptor template.");
            ctx.logError(e.getMessage());
            return StepExitCode.FAIL;
        }
        try {
            List<ConfigurationItem> cis = this.ciParser.fromString(descriptor, ctx.getRepository());
            ctx.logOutput("Successfully parsed " + cis.size() + " CIs");
            this.resultCheck.check(cis);
            return StepExitCode.SUCCESS;
        }
        catch (ResultCheck.Failed e) {
            ctx.logError("Resulted CIs don't meet expectation: " + e.getMessage());
            return StepExitCode.FAIL;
        }
        catch (Exception e) {
            ctx.logError("Can not parse generated XML. " + e.getMessage());
            return StepExitCode.FAIL;
        }
    }
}

