/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.util;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReference;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.xstream.CiXstreamReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CiParser
implements Serializable {
    public List<ConfigurationItem> fromString(String source, Repository repository) {
        try {
            CiXstreamReader reader = new CiXstreamReader(new StaxDriver().createReader((InputStream)new ByteArrayInputStream(source.getBytes())));
            ConfigurationItemConverter converter = new ConfigurationItemConverter();
            List configurationItems = converter.readCis((CiListReader)reader);
            converter.resolveReferences(repository);
            Collection unresolvedReferences = Collections2.filter((Collection)converter.getReferences(), (Predicate)new Predicate<CiReference>(){

                public boolean apply(CiReference input) {
                    return input.getProperty().get(input.getCi()) == null;
                }
            });
            if (unresolvedReferences.size() > 0) {
                CiReference reference = (CiReference)unresolvedReferences.iterator().next();
                throw new ReferenceNotFoundException(reference.getCi().getId(), reference.getProperty().getName(), reference.getIds());
            }
            return configurationItems;
        }
        catch (StreamException e) {
            throw new StreamException(e.getMessage().replaceAll("\\[row,col\\]\\:\\[([0-9]+),([0-9]+)\\]", "row: $1"));
        }
    }

    public class ReferenceNotFoundException
    extends RuntimeException {
        public ReferenceNotFoundException(String id, String property, List<String> referenceIds) {
            super("Can not find reference from " + id + "." + property + " to " + Joiner.on((String)", ").join(referenceIds));
        }
    }
}

