package com.xebialabs.deployit.plugin.cloud.util;

import java.util.Collection;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;

/**
 * Small utility class to help in standard operations with context
 */
public class ContextHelper {

    private ExecutionContext wrapped;

    private ContextHelper(ExecutionContext ctx) {
        this.wrapped = ctx;
    }

    public static ContextHelper wrapped(final ExecutionContext context) {
        return new ContextHelper(context);
    }

    /**
     * Returns an attribute of the context. Null-proof.
     */
    public <T> T safeGet(String key, T initialValue){
        if (wrapped.getAttribute(key) == null) {
            wrapped.setAttribute(key, initialValue);
        }

        @SuppressWarnings("unchecked")
        T value = (T) wrapped.getAttribute(key);
        return value;
    }

    /**
     * Enum alias
     */
    public <T> T safeGet(Enum<?> key, T initialValue){
        return safeGet(key.name(), initialValue);
    }

    /**
     * Sets adds an element to the collection-like attribute of the context. Null-proof.
     */
    public <C, R extends Collection<C>, T extends Collection<C>> R safeSet(String key, R initialValue, T values){
        R collection = safeGet(key, initialValue);
        collection.addAll(values);
        return collection;
    }

    /**
     * Enum alias
     */
    public <C, R extends Collection<C>, T extends Collection<C>> R safeSet(Enum<?> key, R initialValue, T values){
        return safeSet(key.name(), initialValue, values);

    }

}
