package com.xebialabs.deployit.plugin.cloud.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.step.rule.NullCheck;
import com.xebialabs.deployit.plugin.cloud.util.XmlHelper;

import freemarker.template.TemplateException;

import static com.xebialabs.deployit.plugin.cloud.util.ContextHelper.wrapped;

public class ValidateHostDescriptorStep extends ValidateDescriptorStep {

    public ValidateHostDescriptorStep(String descriptorTemplate, BaseHostTemplate hostTemplate) {
        super(descriptorTemplate, hostTemplate.getName(), new NullCheck());

        scope.put("hostsPath", "Infrastructure/exampleHostsLocation");
        scope.put("hostTemplate", hostTemplate);
        scope.put("cloudId", "exampleCloudId");
        scope.put("hostAddress", UUID.randomUUID() + ".cloud.example.com");
    }

    @Override
    protected String resolveTemplate(final String tpl, final Map<Object, Object> initialScope, ExecutionContext ctx) throws TemplateException {
        return descriptorResolver.resolve(tpl, initialScope);
    }


    /**
     * Parses CIs and appends them to the context
     */
    @Override
    protected List<ConfigurationItem> parseCis(final String tpl, final ExecutionContext ctx) {
        List<ConfigurationItem> parsedCis = ciParser.fromString(tpl, ctx.getRepository());

        // Update the context
        ArrayList<ConfigurationItem> oldValue = wrapped(ctx).safeGet(ContextAttribute.PARSED_CIS, new ArrayList<ConfigurationItem>());
        oldValue.addAll(parsedCis);

        return parsedCis;
    }

    /**
     * Replaces password with stars
     */
    @Override
    protected void outputDescriptor(String descriptor, ExecutionContext ctx) {
        ctx.logOutput(XmlHelper.securePassword(descriptor));
    }
}
