package com.xebialabs.deployit.plugin.cloud.util;

import com.google.common.base.Predicate;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.Environment;
import com.xebialabs.deployit.plugin.overthere.Host;

public class CiFilters {

    public static final Type cloudEnvType = Type.valueOf(Environment.class);

    public static final Predicate<ConfigurationItem> CloudEnvironments = new Predicate<ConfigurationItem>() {
        @Override
        public boolean apply(ConfigurationItem ci) {
            return ci.getType().instanceOf(cloudEnvType);
        }
    };

    public static final Predicate<ConfigurationItem> CloudHosts = new Predicate<ConfigurationItem>() {
        @Override
        public boolean apply(ConfigurationItem ci) {
            return ci.getType().instanceOf(Type.valueOf(Host.class));
        }
    };
}