/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cloudburst;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.cloudburst.CloudBurstAppliance;
import com.xebialabs.deployit.cloudburst.CloudBurstCliStep;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.PassThroughCapturingCommandExecutionCallbackHandler;

public class ReadVirtualSystemStep
extends CloudBurstCliStep {
    private String systemName;
    public static final String VIRTUAL_SYSTEM_HOST_NAME_PREFIX = "virtualsystem.hostname.";

    public ReadVirtualSystemStep(CloudBurstAppliance appliance, String systemName) {
        super("Read information about virtual system " + systemName + " using CloudBurst appliance " + (Object)((Object)appliance), appliance, "com/xebialabs/deployit/cloudburst/read-virtual-system.py", systemName);
        this.systemName = systemName;
    }

    @Override
    public boolean execute(StepExecutionContext context) {
        PassThroughCapturingCommandExecutionCallbackHandler handler = new PassThroughCapturingCommandExecutionCallbackHandler((CommandExecutionCallbackHandler)new StepExecutionContextCallbackHandler(context));
        int res = this.execute(handler);
        if (res != 0) {
            return false;
        }
        for (String each : handler.getOutputLines()) {
            if (!each.startsWith("hostname:")) continue;
            String hostname = each.substring("hostname:".length()).trim();
            context.logOutput("Hostname: " + hostname);
            context.setAttribute(VIRTUAL_SYSTEM_HOST_NAME_PREFIX + this.systemName, (Object)hostname);
            return true;
        }
        context.logError("Cannot find hostname in output");
        return false;
    }
}

