/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloudburst;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.mapper.ModificationSupportingStepGeneratingMapper;
import com.xebialabs.deployit.plugin.cloudburst.CloudBurstAppliance;
import com.xebialabs.deployit.plugin.cloudburst.CreateVirtualSystemStep;
import com.xebialabs.deployit.plugin.cloudburst.DeployAndStartEarToDiscoveredWasUnmanagedServerOnVirtualSystemStep;
import com.xebialabs.deployit.plugin.cloudburst.DestroyVirtualSystemStep;
import com.xebialabs.deployit.plugin.cloudburst.DiscoverWasUnmanagedServerOnVirtualSystemStep;
import com.xebialabs.deployit.plugin.cloudburst.EarToCloudBurstApplianceMapping;
import com.xebialabs.deployit.plugin.cloudburst.ReadVirtualSystemStep;
import java.util.List;

public class EarToCloudBurstApplianceMapper
extends ModificationSupportingStepGeneratingMapper<Ear, EarToCloudBurstApplianceMapping, CloudBurstAppliance> {
    public EarToCloudBurstApplianceMapper(Change<Deployment> change) {
        super(change, false);
    }

    protected void generateAdditionStepsForAddedMapping(Ear ear, EarToCloudBurstApplianceMapping mapping, CloudBurstAppliance appliance, List<Step> steps) {
        String patternName = mapping.getPatternName();
        String cloudName = mapping.getCloudGroupName();
        String systemName = mapping.getSystemName();
        String systemPassword = mapping.getSystemPassword();
        steps.add(new CreateVirtualSystemStep(appliance, patternName, cloudName, systemName, systemPassword));
        steps.add(new ReadVirtualSystemStep(appliance, systemName));
        steps.add(new DiscoverWasUnmanagedServerOnVirtualSystemStep(systemName, systemPassword));
        steps.add(new DeployAndStartEarToDiscoveredWasUnmanagedServerOnVirtualSystemStep(ear, systemName));
    }

    protected void generateModificationStepsForModifiedMapping(Ear oldMappingSource, EarToCloudBurstApplianceMapping oldVersionOfModifiedMapping, CloudBurstAppliance oldMappingTarget, Ear newMappingSource, EarToCloudBurstApplianceMapping newVersionOfModifiedMapping, CloudBurstAppliance newMappingTarget, List<Step> steps) {
    }

    protected void generateDeletionStepsForDeletedMapping(Ear ear, EarToCloudBurstApplianceMapping mapping, CloudBurstAppliance appliance, List<Step> steps) {
        String systemName = mapping.getSystemName();
        steps.add(new DestroyVirtualSystemStep(appliance, systemName));
    }
}

