/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jclouds.collect.AbstractMapEntry;

public class InputSupplierMap<K, V>
extends AbstractMap<K, V> {
    final Map<K, InputSupplier<V>> toMap;
    final Function<V, InputSupplier<V>> putFunction;

    public InputSupplierMap(Map<K, InputSupplier<V>> toMap, Function<V, InputSupplier<V>> putFunction) {
        this.toMap = Preconditions.checkNotNull(toMap);
        this.putFunction = Preconditions.checkNotNull(putFunction);
    }

    @Override
    public int size() {
        return this.toMap.size();
    }

    @Override
    public V put(K key, V value) {
        V old = this.get(key);
        this.toMap.put(key, value != null ? this.putFunction.apply(value) : null);
        return old;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.toMap.containsKey(key);
    }

    @Override
    public V get(Object key) {
        InputSupplier<V> value = this.toMap.get(key);
        try {
            return value != null ? (V)value.getInput() : null;
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public V remove(Object key) {
        try {
            return this.toMap.containsKey(key) ? (V)this.toMap.remove(key).getInput() : null;
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void clear() {
        this.toMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return InputSupplierMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator mapIterator = InputSupplierMap.this.toMap.entrySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return mapIterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    final Map.Entry entry = (Map.Entry)mapIterator.next();
                    return new AbstractMapEntry<K, V>(){

                        @Override
                        public K getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            try {
                                return ((InputSupplier)entry.getValue()).getInput();
                            }
                            catch (IOException e) {
                                throw Throwables.propagate(e);
                            }
                        }
                    };
                }

                @Override
                public void remove() {
                    mapIterator.remove();
                }
            };
        }

        @Override
        public void clear() {
            InputSupplierMap.this.toMap.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            Object mapValue = InputSupplierMap.this.get(entryKey);
            if (mapValue != null) {
                return mapValue.equals(entryValue);
            }
            return entryValue == null && InputSupplierMap.this.containsKey(entryKey);
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                InputSupplierMap.this.toMap.remove(key);
                return true;
            }
            return false;
        }
    }
}

