/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.util.IpPermissions;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindIpPermissionsToIndexedFormParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Iterable, "this binder is only valid for Iterable<IpPermission>");
        ImmutableMultimap.Builder<String, String> formBuilder = ImmutableMultimap.builder();
        int index = 0;
        for (IpPermission perm : (Iterable)input) {
            formBuilder.putAll(IpPermissions.buildFormParametersForIndex(index++, perm));
        }
        ImmutableMultimap<String, String> forms = formBuilder.build();
        return (R)(forms.size() == 0 ? request : ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceFormParams(forms)).build());
    }
}

